/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.EntrezGeneDbParser$EntrezFileSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.vdb.Organism;
import edu.mit.broad.vdb.meg.EntrezGene;
import edu.mit.broad.vdb.meg.EntrezGene$GeneIdAccessionSet;
import edu.mit.broad.vdb.meg.EntrezGene$Helper;
import edu.mit.broad.vdb.meg.EntrezGeneDb;
import edu.mit.broad.vdb.meg.EntrezGeneImpl;
import edu.mit.broad.vdb.meg.GeneDb;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntrezGeneDbParser
extends AbstractParser {
    private static Set kValid_gene_types;

    public EntrezGeneDbParser() {
        super(GeneDb.class);
    }

    @Override
    public final void export(PersistentObject persistentObject, File file) {
        throw new NotImplementedException();
    }

    @Override
    public final List parse(String string, InputStream inputStream) {
        throw new NotImplementedException();
    }

    public static final Set getValidGeneTypes() {
        if (kValid_gene_types == null) {
            kValid_gene_types = new HashSet();
            kValid_gene_types.add("protein-coding");
            kValid_gene_types.add("pseudo");
            kValid_gene_types.add("other");
            kValid_gene_types.add("miscRNA");
            kValid_gene_types.add("unknown");
            kValid_gene_types.add("snoRNA");
            kValid_gene_types.add("snRNA");
            kValid_gene_types = Collections.unmodifiableSet(kValid_gene_types);
        }
        return kValid_gene_types;
    }

    public final EntrezGeneDb parseEntrezDb(File file, boolean bl) {
        return this.parseEntrezDb(new EntrezGeneDbParser$EntrezFileSet(file, new Organism[]{Organism.HUMAN}), true);
    }

    public final EntrezGeneDb parseEntrezDb(EntrezGeneDbParser$EntrezFileSet entrezGeneDbParser$EntrezFileSet, boolean bl) {
        return this.parseEntrezDb(entrezGeneDbParser$EntrezFileSet, new Organism[]{Organism.HUMAN});
    }

    public final EntrezGeneDb parseEntrezDb(EntrezGeneDbParser$EntrezFileSet entrezGeneDbParser$EntrezFileSet, Organism[] organismArray) {
        EntrezGeneDb entrezGeneDb = new EntrezGeneDbParser().parseEntrezDb_only_gene_info(EntrezGeneDbParser$EntrezFileSet.access$000(entrezGeneDbParser$EntrezFileSet), entrezGeneDbParser$EntrezFileSet.getOrganisms());
        EntrezGene$GeneIdAccessionSet[] entrezGene$GeneIdAccessionSetArray = this.parseEntrezGeneAccessions(EntrezGeneDbParser$EntrezFileSet.access$100(entrezGeneDbParser$EntrezFileSet), entrezGeneDbParser$EntrezFileSet.getOrganisms());
        EntrezGene$GeneIdAccessionSet[] entrezGene$GeneIdAccessionSetArray2 = this.parseEntrezGeneRefSeq(EntrezGeneDbParser$EntrezFileSet.access$200(entrezGeneDbParser$EntrezFileSet), entrezGeneDbParser$EntrezFileSet.getOrganisms());
        EntrezGene$GeneIdAccessionSet[] entrezGene$GeneIdAccessionSetArray3 = this.parseEntrezGeneUnigene(EntrezGeneDbParser$EntrezFileSet.access$300(entrezGeneDbParser$EntrezFileSet), entrezGeneDbParser$EntrezFileSet.getOrganisms());
        ArrayList<EntrezGene$GeneIdAccessionSet> arrayList = new ArrayList<EntrezGene$GeneIdAccessionSet>();
        arrayList.addAll(Arrays.asList(entrezGene$GeneIdAccessionSetArray));
        arrayList.addAll(Arrays.asList(entrezGene$GeneIdAccessionSetArray2));
        arrayList.addAll(Arrays.asList(entrezGene$GeneIdAccessionSetArray3));
        EntrezGene$GeneIdAccessionSet[] entrezGene$GeneIdAccessionSetArray4 = arrayList.toArray(new EntrezGene$GeneIdAccessionSet[arrayList.size()]);
        this.log.info("sets_acc: " + entrezGene$GeneIdAccessionSetArray.length + " sets_refseq: " + entrezGene$GeneIdAccessionSetArray2.length + " sets_unigene: " + entrezGene$GeneIdAccessionSetArray3.length + " all: " + entrezGene$GeneIdAccessionSetArray4.length);
        Map map = EntrezGene$Helper.toMap(entrezGene$GeneIdAccessionSetArray4);
        entrezGeneDb.cloneShallow(map);
        return entrezGeneDb;
    }

    public final EntrezGeneDb parseEntrezDb_only_gene_info(File file, boolean bl) {
        return this.parseEntrezDb_only_gene_info(file, new Organism[]{Organism.HUMAN});
    }

    public final EntrezGeneDb parseEntrezDb_only_gene_info(File file, Organism[] organismArray) {
        ArrayList<EntrezGeneImpl> arrayList = new ArrayList<EntrezGeneImpl>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = this.nextLineTrimless(bufferedReader);
        string = this.nextLineTrimless(bufferedReader);
        Set set = Organism.getTaxIds(organismArray);
        this.log.debug("Allowed tax ids: " + set);
        Set set2 = EntrezGeneDbParser.getValidGeneTypes();
        int n = 0;
        while (string != null) {
            String[] stringArray = ParseUtils.string2strings(string, "\t", false);
            String string2 = stringArray[0];
            boolean bl = false;
            String string3 = stringArray[9];
            if (set.contains(string2)) {
                bl = true;
            }
            if (!set2.contains(string3)) {
                bl = false;
            }
            if (bl) {
                String string4 = stringArray[1];
                String string5 = stringArray[2];
                String string6 = stringArray[8];
                String string7 = stringArray[7];
                String string8 = stringArray[4];
                String string9 = stringArray[12];
                Set set3 = ParseUtils.string2stringsSet(string8, "|", false);
                set3.remove("-");
                arrayList.add(new EntrezGeneImpl(Integer.parseInt(string4), Integer.parseInt(string2), string5, string6, set3, string7, null, string9));
            }
            string = this.nextLineTrimless(bufferedReader);
            if (++n % 100000 != 0) continue;
            System.out.println("Done entrez line: " + n + " #=" + arrayList.size());
        }
        bufferedReader.close();
        return new EntrezGeneDb(file, new Version(1), arrayList.toArray(new EntrezGene[arrayList.size()]));
    }

    public final EntrezGene$GeneIdAccessionSet[] parseEntrezGeneAccessions(File file, Organism[] organismArray) {
        Object[] objectArray;
        HashMap hashMap = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = this.nextLineTrimless(bufferedReader);
        Set set = Organism.getTaxIds(organismArray);
        this.log.debug("Allowed tax ids: " + set);
        int n = 0;
        while (string != null) {
            objectArray = ParseUtils.string2strings(string, "\t", false);
            long l2 = Long.parseLong(objectArray[0]);
            long l3 = Long.parseLong((String)objectArray[1]);
            String string2 = l3 + "";
            Object object = objectArray[3];
            boolean bl = false;
            if (set.contains("" + l2)) {
                bl = true;
            }
            if (object == null || ((String)object).length() == 0 || ((String)object).equals("-")) {
                bl = false;
            }
            if (bl) {
                object = NamingConventions.removeExtension((String)object);
                Object object2 = hashMap.get(string2);
                if (object2 == null) {
                    object2 = new HashSet();
                }
                ((Set)object2).add(object);
                hashMap.put(string2, object2);
            }
            string = this.nextLineTrimless(bufferedReader);
            if (++n % 100000 != 0) continue;
            System.out.println("Done entrez gene accessions line: " + n + " #=" + hashMap.size());
        }
        bufferedReader.close();
        objectArray = new EntrezGene$GeneIdAccessionSet[hashMap.size()];
        int n2 = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next().toString();
            Object v = hashMap.get(string3);
            objectArray[n2++] = new EntrezGene$GeneIdAccessionSet(Long.parseLong(string3), (Set)v);
        }
        this.log.info("Made SymbolAccessions: " + objectArray.length);
        return objectArray;
    }

    public final EntrezGene$GeneIdAccessionSet[] parseEntrezGeneRefSeq(File file, Organism[] organismArray) {
        Object[] objectArray;
        HashMap hashMap = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = this.nextLineTrimless(bufferedReader);
        Set set = Organism.getTaxIds(organismArray);
        this.log.debug("Allowed tax ids: " + set);
        int n = 0;
        while (string != null) {
            objectArray = ParseUtils.string2strings(string, "\t", false);
            long l2 = Long.parseLong(objectArray[0]);
            long l3 = Long.parseLong((String)objectArray[1]);
            String string2 = l3 + "";
            Object object = objectArray[3];
            boolean bl = false;
            if (set.contains(l2 + "")) {
                bl = true;
            }
            if (object == null || ((String)object).length() == 0 || ((String)object).equals("-")) {
                bl = false;
            }
            if (bl) {
                object = NamingConventions.removeExtension((String)object);
                Object object2 = hashMap.get(string2);
                if (object2 == null) {
                    object2 = new HashSet();
                }
                ((Set)object2).add(object);
                hashMap.put(string2, object2);
            }
            string = this.nextLineTrimless(bufferedReader);
            if (++n % 100000 != 0) continue;
            System.out.println("Done entrez gene refseqs line: " + n + " #=" + hashMap.size());
        }
        bufferedReader.close();
        objectArray = new EntrezGene$GeneIdAccessionSet[hashMap.size()];
        int n2 = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next().toString();
            Object v = hashMap.get(string3);
            objectArray[n2++] = new EntrezGene$GeneIdAccessionSet(Long.parseLong(string3), (Set)v);
        }
        this.log.info("Made GeneRefSeq: " + objectArray.length);
        return objectArray;
    }

    public final EntrezGene$GeneIdAccessionSet[] parseEntrezGeneUnigene(File file, Organism[] organismArray) {
        Object object;
        Object object2;
        Object[] objectArray;
        HashMap hashMap = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = this.nextLineTrimless(bufferedReader);
        Set set = Organism.getUnigeneCodes(organismArray);
        this.log.debug("Allowed tax ids: " + set);
        int n = 0;
        while (string != null) {
            objectArray = ParseUtils.string2strings(string, "\t", false);
            if (objectArray.length != 2) {
                throw new ParserException("Expected 2 fields got: " + objectArray.length + " line >" + string + "<");
            }
            long l2 = Long.parseLong((String)objectArray[0]);
            object2 = objectArray[1];
            if (object2 == null || ((String)object2).length() == 0 || ((String)object2).equals("-")) continue;
            object = NamingConventions.removeExtension((String)object2);
            boolean bl = false;
            if (set.contains(object)) {
                bl = true;
            }
            if (bl) {
                Object object3 = hashMap.get("" + l2);
                if (object3 == null) {
                    object3 = new HashSet();
                }
                ((Set)object3).add(object2);
                hashMap.put("" + l2, object3);
            }
            string = this.nextLineTrimless(bufferedReader);
            if (++n % 25000 != 0) continue;
            System.out.println("Done entrez gene accessions line: " + n + " #=" + hashMap.size());
        }
        bufferedReader.close();
        objectArray = new EntrezGene$GeneIdAccessionSet[hashMap.size()];
        int n2 = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().toString();
            object = hashMap.get(object2);
            objectArray[n2++] = new EntrezGene$GeneIdAccessionSet(Long.parseLong((String)object2), (Set)object);
        }
        this.log.info("Made GeneRefSeq: " + objectArray.length);
        return objectArray;
    }
}

