/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.NotSpecifiedBoxWrapper;
import edu.mit.broad.genome.parsers.ObjectCache$1;
import edu.mit.broad.genome.parsers.ObjectCache$ExtraCache;
import edu.mit.broad.genome.parsers.ObjectCache$PathClass;
import edu.mit.broad.genome.parsers.PobBoxModel;
import edu.mit.broad.genome.parsers.PobBoxModels;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.ProxyComboBoxModel;
import edu.mit.broad.genome.swing.ProxyTreeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class ObjectCache {
    private final Logger log = XLogger.getLogger(ObjectCache.class);
    private final Map fClassNameNodeMap = new Hashtable();
    private final Map fClassNameBoxModelMap = new Hashtable();
    private final DefaultTreeModel fTreeModel;
    private final DefaultMutableTreeNode fRootNode;
    private Map fIdCachesExtra = new HashMap();
    private final Map fPathClassObjectMap = new HashMap();
    private final Map fObjectPathStringMap = new HashMap();
    private final Map fInvisiblePobFileMap = new HashMap();
    private final PropertyChangeSupport fPathChanges = new PropertyChangeSupport(this);
    private final PropertyChangeSupport fReportChanges = new PropertyChangeSupport(this);
    public static final String PROP_PATH_ADDED = "path_added";
    public static final String PROP_REPORT_ADDED = "pob_added";
    private PobBoxModel auxsetsmodel;

    public ObjectCache() {
        this("<html><body><font type=bold>Objects in memory</font><font color=gray size=-2> [shift-click to expand all]</font></body></html>");
    }

    private ObjectCache(String string) {
        this.fRootNode = new DefaultMutableTreeNode(string);
        this.fTreeModel = new DefaultTreeModel(this.fRootNode, true);
    }

    public final boolean isCached(String string, Class clazz) {
        return this.fPathClassObjectMap.containsKey(new ObjectCache$PathClass(this, string, clazz, null));
    }

    public final boolean isCached(File file, Class clazz) {
        return this.isCached(file.getPath(), clazz);
    }

    public final boolean isCached(PersistentObject persistentObject) {
        if (this.fObjectPathStringMap.containsKey(persistentObject)) {
            return true;
        }
        return this.fInvisiblePobFileMap.containsKey(persistentObject);
    }

    public final Object get(String string, Class clazz) {
        return this.fPathClassObjectMap.get(new ObjectCache$PathClass(this, string, clazz, null));
    }

    public final Object get(File file, Class clazz) {
        return this.fPathClassObjectMap.get(new ObjectCache$PathClass(this, file.getPath(), clazz, null));
    }

    public final String getSourcePath(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        Object object2 = this.fObjectPathStringMap.get(object);
        if (object2 == null && this.fInvisiblePobFileMap.containsKey(object)) {
            object2 = ((File)this.fInvisiblePobFileMap.get(object)).getPath();
        }
        if (object2 != null) {
            return object2.toString();
        }
        throw new IllegalArgumentException("Unknown cache object -- use isCached() to check first if appropriate: " + object + " class: " + object.getClass());
    }

    public final File getSourceFile(Object object) {
        String string = this.getSourcePath(object);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public final void add(File file, PersistentObject persistentObject, Class clazz) {
        this.add(file.getPath(), persistentObject, clazz);
    }

    protected final void add(File file, PersistentObject persistentObject, Class clazz, boolean bl) {
        this.add(file.getPath(), persistentObject, clazz, bl);
    }

    protected final void add(String[] stringArray, PersistentObject[] persistentObjectArray, Class clazz) {
        if (stringArray.length != persistentObjectArray.length) {
            throw new IllegalArgumentException("Expect files and pobs to be of equal length: " + stringArray.length + " " + persistentObjectArray.length);
        }
        if (stringArray.length == 1) {
            this.add(stringArray[0], persistentObjectArray[0], clazz, true);
        } else {
            int n;
            for (n = 0; n < stringArray.length - 1; ++n) {
                this.add(stringArray[n], persistentObjectArray[n], clazz, false);
            }
            this.add(stringArray[n], persistentObjectArray[n], clazz, true);
        }
    }

    protected final void add(String string, PersistentObject persistentObject, Class clazz) {
        this.add(string, persistentObject, clazz, true);
    }

    protected final void add(String string, PersistentObject persistentObject, Class clazz, boolean bl) {
        PobBoxModel pobBoxModel;
        DefaultMutableTreeNode defaultMutableTreeNode;
        ObjectCache$PathClass objectCache$PathClass = new ObjectCache$PathClass(this, string, clazz, null);
        if (this.fObjectPathStringMap.containsKey(persistentObject) && !(persistentObject instanceof Template)) {
            this.log.debug("Already cached object: " + persistentObject + " in: " + this.fObjectPathStringMap.get(persistentObject));
        }
        this.fPathClassObjectMap.put(objectCache$PathClass, persistentObject);
        this.fObjectPathStringMap.put(persistentObject, string);
        String string2 = clazz.getName();
        if (this.fClassNameNodeMap.get(string2) == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(string2);
            this.fClassNameNodeMap.put(string2, defaultMutableTreeNode);
            this.fTreeModel.insertNodeInto(defaultMutableTreeNode, this.fRootNode, this.fRootNode.getChildCount());
        }
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.fClassNameNodeMap.get(string2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(persistentObject, false);
        this.cleanupNode(persistentObject, string, defaultMutableTreeNode);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        try {
            if (bl) {
                this.fTreeModel.reload(defaultMutableTreeNode);
            }
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
        }
        if (this.fClassNameBoxModelMap.get(string2) == null) {
            pobBoxModel = new PobBoxModel();
            this.fClassNameBoxModelMap.put(string2, pobBoxModel);
        }
        if ((pobBoxModel = (PobBoxModel)this.fClassNameBoxModelMap.get(string2)).getIndexOf(persistentObject) == -1) {
            if (bl) {
                this.cleanupModel(persistentObject, string, pobBoxModel);
            }
            pobBoxModel.addElement(persistentObject);
            if (bl) {
                this.firePathAdded(new PropertyChangeEvent(this, PROP_PATH_ADDED, null, string));
                if (persistentObject instanceof Report) {
                    this.fireReportAdded(new PropertyChangeEvent(this, PROP_REPORT_ADDED, null, persistentObject));
                }
            }
        }
        for (Object k2 : this.fIdCachesExtra.keySet()) {
            ObjectCache$ExtraCache objectCache$ExtraCache = (ObjectCache$ExtraCache)this.fIdCachesExtra.get(k2);
            if (!objectCache$ExtraCache.isMember(string)) continue;
            ObjectCache$ExtraCache.access$100(objectCache$ExtraCache).add(string, persistentObject, clazz, bl);
        }
    }

    private void cleanupNode(PersistentObject persistentObject, String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            PersistentObject persistentObject2 = (PersistentObject)defaultMutableTreeNode2.getUserObject();
            String string2 = this.getSourcePath(persistentObject2);
            if (string2 == null || !string2.equals(string) || !persistentObject2.getName().equals(persistentObject.getName())) continue;
            arrayList.add(new Integer(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            defaultMutableTreeNode.remove((Integer)arrayList.get(n));
        }
    }

    private void cleanupModel(PersistentObject persistentObject, String string, PobBoxModel pobBoxModel) {
        int n;
        ArrayList<PersistentObject> arrayList = new ArrayList<PersistentObject>();
        for (n = 0; n < pobBoxModel.getSize(); ++n) {
            PersistentObject persistentObject2 = (PersistentObject)pobBoxModel.getElementAt(n);
            String string2 = this.getSourcePath(persistentObject2);
            if (string2 == null || !string2.equals(string) || !persistentObject2.getName().equals(persistentObject.getName())) continue;
            arrayList.add(persistentObject2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            pobBoxModel.removeElement(arrayList.get(n));
        }
    }

    protected final void sortModel(Class clazz) {
        Object v = this.fClassNameBoxModelMap.get(clazz.getName());
        if (v == null) {
            this.log.debug("no object model yet for class: " + clazz);
            return;
        }
        PobBoxModel pobBoxModel = (PobBoxModel)v;
        pobBoxModel.sort();
    }

    public final TreeModel createTreeModel() {
        return new ProxyTreeModel(this.fTreeModel);
    }

    public final TreeModel createTreeModel(String string, String string2) {
        if (this.fIdCachesExtra.containsKey(string)) {
            this.log.debug("Reusing ObjectCache for id: " + string);
        } else {
            this.log.debug("Makign a new ObjectCache for id: " + string);
            ObjectCache$ExtraCache objectCache$ExtraCache = new ObjectCache$ExtraCache(string, string2);
            this.fIdCachesExtra.put(string, objectCache$ExtraCache);
        }
        return ObjectCache$ExtraCache.access$100((ObjectCache$ExtraCache)this.fIdCachesExtra.get(string)).createTreeModel();
    }

    public final ComboBoxModel createBoxModel(Class clazz) {
        return this.createBoxModel(clazz, false);
    }

    public final ComboBoxModel createBoxModel(Class clazz, boolean bl) {
        PobBoxModel pobBoxModel = this._createBoxModel(clazz);
        if (bl) {
            return new ProxyComboBoxModel(pobBoxModel);
        }
        return new ProxyComboBoxModel(pobBoxModel);
    }

    public final PobBoxModel _createBoxModel(Class clazz) {
        PobBoxModel pobBoxModel;
        Object v = this.fClassNameBoxModelMap.get(clazz.getName());
        if (v != null) {
            pobBoxModel = (PobBoxModel)v;
        } else {
            pobBoxModel = new PobBoxModel();
            this.fClassNameBoxModelMap.put(clazz.getName(), pobBoxModel);
        }
        return pobBoxModel;
    }

    protected final void hackAddAuxSets(GeneSetMatrix geneSetMatrix) {
        if (this.auxsetsmodel == null) {
            this.auxsetsmodel = new PobBoxModel();
        }
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            this.auxsetsmodel.addElement(geneSetMatrix.getGeneSet(i2));
        }
        this.auxsetsmodel.sort();
    }

    public final PobBoxModel hackCreateAuxGeneSetsBoxModel() {
        if (this.auxsetsmodel == null) {
            this.auxsetsmodel = new PobBoxModel();
        }
        return this.auxsetsmodel;
    }

    public final ComboBoxModel createBoxModel(Class[] classArray, boolean bl) {
        PobBoxModel[] pobBoxModelArray = new PobBoxModel[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            pobBoxModelArray[i2] = this._createBoxModel(classArray[i2]);
        }
        PobBoxModels pobBoxModels = new PobBoxModels(pobBoxModelArray);
        if (bl) {
            return new NotSpecifiedBoxWrapper(pobBoxModels);
        }
        return pobBoxModels;
    }

    public final PersistentObject[] getCachedObjects(Class clazz) {
        List list = this.getCachedObjectsL(clazz);
        return list.toArray(new PersistentObject[list.size()]);
    }

    public final List getCachedObjectsL(Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (ObjectCache$PathClass objectCache$PathClass : this.fPathClassObjectMap.keySet()) {
            if (!ObjectCache$PathClass.access$200(objectCache$PathClass).equals(clazz)) continue;
            arrayList.add(this.fPathClassObjectMap.get(objectCache$PathClass));
        }
        return arrayList;
    }

    public final void addPathAdditionsListener(PropertyChangeListener propertyChangeListener) {
        this.fPathChanges.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePathAdditionsListener(PropertyChangeListener propertyChangeListener) {
        this.fPathChanges.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePathAdded(PropertyChangeEvent propertyChangeEvent) {
        this.fPathChanges.firePropertyChange(propertyChangeEvent);
    }

    public final void addReportAdditionsListener(PropertyChangeListener propertyChangeListener) {
        this.fReportChanges.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removeReportAdditionsListener(PropertyChangeListener propertyChangeListener) {
        this.fReportChanges.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireReportAdded(PropertyChangeEvent propertyChangeEvent) {
        this.fReportChanges.firePropertyChange(propertyChangeEvent);
    }

    public final void makeVisible(PersistentObject persistentObject, Class clazz) {
        this.makeVisible(new PersistentObject[]{persistentObject}, clazz);
    }

    public final void makeVisible(PersistentObject[] persistentObjectArray, Class clazz) {
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            Object v = this.fInvisiblePobFileMap.get(persistentObjectArray[i2]);
            if (v == null) continue;
            this.fInvisiblePobFileMap.remove(persistentObjectArray[i2]);
            this.add((File)v, persistentObjectArray[i2], clazz, false);
        }
        this.sortModel(clazz);
    }

    protected final void addInvisibly(File file, PersistentObject persistentObject) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        if (persistentObject == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (this.fInvisiblePobFileMap.containsKey(persistentObject)) {
            this.log.warn("Already registered: " + persistentObject.getName() + " overwritting");
        }
        this.fInvisiblePobFileMap.put(persistentObject, file);
    }

    protected final void addInvisibly(String string, PersistentObject persistentObject) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        this.addInvisibly(new File(string), persistentObject);
    }

    /* synthetic */ ObjectCache(String string, ObjectCache$1 objectCache$1) {
        this(string);
    }
}

