/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.AlgMap;
import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.DatasetStatsCore$TwoClassMarkerStats;
import edu.mit.broad.genome.alg.TemplateStats;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.alg.markers.PermutationTestImpl;
import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartImpl;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.reports.ChartHelper;
import edu.mit.broad.genome.reports.MiscReports;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.RichDataframe$MetaData;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.KeyValTable;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.heatmap.GramImager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import xapps.api.vtools.viewers.VizFactory;

public class PermutationReports
extends ChartHelper {
    private PermutationReports() {
    }

    public static final void createDetailedReports(PermutationTest permutationTest, ToolReport toolReport, boolean bl, boolean bl2, boolean bl3) {
        File file = toolReport.getReportDir();
        if (bl) {
            file = toolReport.createSubDir(permutationTest.getName());
        }
        PermutationReports.createDetailedReports(permutationTest, toolReport, file, bl2, bl3);
    }

    public static final void createDetailedReports(PermutationTest permutationTest, ToolReport toolReport, File file, boolean bl, boolean bl2) {
        String string;
        String string2;
        Object object;
        String string3;
        String string4;
        Template template = permutationTest.getTemplate();
        if (template.isContinuous()) {
            string4 = "positive correlation with profile";
            string3 = "negative correlation with profile";
            object = AuxUtils.getAuxNameOnlyNoHash(template);
            if (template.isContinuous()) {
                string2 = object;
                string = object;
            } else {
                string2 = (String)object + "_pos";
                string = (String)object + "_neg";
            }
        } else {
            string4 = template.getClassName(0) + " (" + template.getClass(0).getSize() + " samples)";
            string3 = template.getClassName(1) + " (" + template.getClass(1).getSize() + " samples)";
            string2 = template.getClassName(0);
            string = template.getClassName(1);
        }
        object = toolReport.getIndexPage();
        ((HtmlPage)object).startSection("Marker permutation report for: " + permutationTest.getName() + "<br>classA: " + string4 + "<br>classB: " + string3);
        try {
            if (bl) {
                ((HtmlPage)object).addImage("bpog", "Heat map of " + permutationTest.getNumMarkers(), "Heat map of " + permutationTest.getNumMarkers(), PermutationReports.createUpDnMarkersBpog(permutationTest), 600, 600);
            }
        }
        catch (Throwable throwable) {
            toolReport.addError("trouble making bpog/charts", throwable);
        }
        ((HtmlPage)object).addChart(PermutationReports.createButterflyChart(permutationTest), 600, 600);
        RichDataframe richDataframe = MiscReports.annotateProbesNames(permutationTest.getName(), permutationTest.getRankedList(), permutationTest.getDataset().getAnnot().getFeatureAnnot());
        toolReport.savePageXls(richDataframe, "ranked_gene_list", file);
        toolReport.savePage(permutationTest.getUpandDnMarkers(), file);
        toolReport.savePageXls((IDataframe)PermutationReports.createSignificanceReport(permutationTest, permutationTest.getDataset().getAnnot().getChip()), "permutation_" + string2 + " _vs_" + string, file);
        RichDataframe richDataframe2 = PermutationReports.createMetricCrossOverReport(permutationTest);
        RichDataframe richDataframe3 = PermutationReports.createMetricWeightReport(permutationTest);
        ((HtmlPage)object).addTable("cross_over_details", richDataframe2.getMetaData().getKvt());
        toolReport.savePage("rnd_cross_over_distrib", "Distribution of marker cross-over fractions the random phenotypes", richDataframe2.getDataframe(), file, false);
        ((HtmlPage)object).addTable("weight_details", richDataframe3.getMetaData().getKvt());
        toolReport.savePage("rnd_weight_distrib", "Distribution of marker weights for the random phenotypes", richDataframe3.getDataframe(), file, false);
        if (bl2) {
            toolReport.savePage((PersistentObject)permutationTest.getRandomScores(true), file);
            toolReport.savePage((PersistentObject)permutationTest.getRandomScores(false), file);
        }
        ((HtmlPage)object).endSection();
    }

    public static final Vector calcHammingDistances(PermutationTest permutationTest) {
        return TemplateStats.calcAverageHammingDists(permutationTest.getTemplate(), permutationTest.getTemplatesRandom());
    }

    public static final RichDataframe createMetricCrossOverReport(PermutationTest permutationTest) {
        String[] stringArray = new String[]{"RANK", "FRACTION"};
        Vector vector = new Vector(permutationTest.getMetricCrossOverRanks());
        Vector vector2 = new Vector(permutationTest.getMetricCrossOverRanks());
        vector2.divide(permutationTest.getDataset().getNumRow());
        StringMatrix stringMatrix = new StringMatrix(vector.getSize(), stringArray.length);
        stringMatrix.setColumn(0, vector);
        stringMatrix.setColumn(1, vector2);
        StringDataframe stringDataframe = new StringDataframe("crossover_points_" + permutationTest.getName(), stringMatrix, true);
        KeyValTable keyValTable = new KeyValTable(2);
        keyValTable.addRow("REAL_CROSS_OVER_RANK", permutationTest.getRealMetricCrossOverRank());
        keyValTable.addRow("REAL_CROSS_OVER_FRAC", (float)permutationTest.getRealMetricCrossOverRank() / (float)permutationTest.getDataset().getNumRow());
        keyValTable.addRow("RANDOM_CROSSOVER_RANK_MEDIAN", vector.median());
        keyValTable.addRow("RANDOM_CROSSOVER_RANK_STDEV", vector.stddev(true, false));
        keyValTable.addRow("RANDOM_CROSSOVER_FRAC_MEDIAN", vector2.median());
        keyValTable.addRow("RANDOM_CROSSOVER_FRAC_STDEV", vector2.stddev(true, false));
        RichDataframe$MetaData richDataframe$MetaData = new RichDataframe$MetaData(keyValTable);
        return new RichDataframe(stringDataframe, richDataframe$MetaData);
    }

    public static final RichDataframe createMetricWeightReport(PermutationTest permutationTest) {
        Object object;
        MetricWeightStruc[] metricWeightStrucArray = permutationTest.getRandomMetricWeights();
        String[] stringArray = new String[]{"POS_WEIGHT", "NEG_WEIGHT", "DELTA", "TOTAL_WEIGHT", "POS_WEIGHT_FRACTION", "NEG_WEIGHT_FRACTION", "DELTA_WEIGHT_FRACTION"};
        StringMatrix stringMatrix = new StringMatrix(metricWeightStrucArray.length, stringArray.length);
        for (int i2 = 0; i2 < metricWeightStrucArray.length; ++i2) {
            object = metricWeightStrucArray[i2];
            int n = 0;
            stringMatrix.setElement(i2, n++, object.getTotalPosWeight());
            stringMatrix.setElement(i2, n++, object.getTotalNegWeight());
            stringMatrix.setElement(i2, n++, object.getDeltaWeight());
            stringMatrix.setElement(i2, n++, object.getTotalWeight());
            stringMatrix.setElement(i2, n++, object.getTotalPosWeight_frac());
            stringMatrix.setElement(i2, n++, object.getTotalNegWeight_frac());
            stringMatrix.setElement(i2, n, object.getDeltaWeight());
        }
        StringDataframe stringDataframe = new StringDataframe("crossover_points_" + permutationTest.getName(), stringMatrix, stringArray, true);
        object = new KeyValTable(2);
        Vector vector = stringMatrix.getColumnAsVector(2, false);
        ((KeyValTable)object).addRow("REAL_DELTA", permutationTest.getRealMetricWeight().getDeltaWeight());
        ((KeyValTable)object).addRow("RANDOM_DELTA_MEAN", vector.mean());
        ((KeyValTable)object).addRow("RANDOM_DELTA_MEDIAN", vector.median());
        ((KeyValTable)object).addRow("RANDOM_DELTA_STDEV", vector.stddev(true, false));
        Vector vector2 = stringMatrix.getColumnAsVector(3, false);
        ((KeyValTable)object).addRow("REAL_TOTAL", permutationTest.getRealMetricWeight().getTotalWeight());
        ((KeyValTable)object).addRow("RANDOM_TOTAL_MEAN", vector2.mean());
        ((KeyValTable)object).addRow("RANDOM_TOTAL_MEDIAN", vector2.median());
        ((KeyValTable)object).addRow("RANDOM_TOTAL_STDEV", vector2.stddev(true, false));
        RichDataframe$MetaData richDataframe$MetaData = new RichDataframe$MetaData((KeyValTable)object);
        return new RichDataframe(stringDataframe, richDataframe$MetaData);
    }

    public static final Dataset createUpDnMarkersDataset(PermutationTest permutationTest) {
        GeneSet geneSet = permutationTest.getUpandDnMarkers().getBoth();
        return new DatasetGenerators().extractRowsSorted(permutationTest.getScoredDataset(), geneSet);
    }

    public static final BufferedImage createUpDnMarkersBpog(PermutationTest permutationTest) {
        ScoredDataset scoredDataset = permutationTest.getScoredDataset();
        Dataset dataset = new DatasetGenerators().extractRowsSorted(scoredDataset, permutationTest.getUpandDnMarkers().getBoth());
        return VizFactory.createGramImager().createBpogImage(dataset, permutationTest.getTemplate());
    }

    public static final BufferedImage createCombinedMarkersBpog(Dataset dataset, PermutationTest[] permutationTestArray, boolean bl) {
        Object object;
        PersistentObject persistentObject;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Template[] templateArray = new Template[permutationTestArray.length];
        for (int i2 = 0; i2 < permutationTestArray.length; ++i2) {
            persistentObject = permutationTestArray[i2].getUpandDnMarkers().get(bl);
            arrayList.addAll(persistentObject.getMembers());
            object = permutationTestArray[i2].getTemplate().getClass(0).getProfilePositions();
            for (int i3 = 0; i3 < ((int[])object).length; ++i3) {
                arrayList2.add(permutationTestArray[i2].getDataset().getColumnName(object[i3]));
            }
            templateArray[i2] = permutationTestArray[i2].getTemplate();
        }
        DatasetGenerators datasetGenerators = new DatasetGenerators();
        persistentObject = datasetGenerators.extractRows(dataset, new FSet("combo", arrayList, false));
        persistentObject = datasetGenerators.orderDatasetColumns(persistentObject.getName() + "col_ordered", arrayList2, (Dataset)persistentObject, true);
        object = TemplateFactory.createCombinedTemplateUsingClass0("combined", templateArray);
        GramImager gramImager = VizFactory.createGramImager();
        return gramImager.createBpogImage((Dataset)persistentObject, (Template)object);
    }

    public static final XChart createButterflyChart(PermutationTest permutationTest) {
        int n;
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        Dataset dataset = permutationTest.getSigLevels(true);
        Dataset dataset2 = permutationTest.getSigLevels(false);
        Vector vector = new Vector(permutationTest.getNumMarkers());
        for (int i2 = 0; i2 < permutationTest.getNumMarkers(); ++i2) {
            vector.setElement(i2, i2 + 1);
        }
        float[] fArray = permutationTest.getSigLevels();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("Observed pos");
        arrayList2.add("Observed neg");
        RankedList rankedList = permutationTest.getRankedList();
        Vector vector2 = new Vector(permutationTest.getNumMarkers());
        for (n = 0; n < permutationTest.getNumMarkers(); ++n) {
            vector2.setElement(n, rankedList.getScore(n));
        }
        arrayList.add(vector2);
        n = rankedList.getSize() - 1;
        vector2 = new Vector(permutationTest.getNumMarkers());
        int n2 = 0;
        while (n2 < permutationTest.getNumMarkers()) {
            vector2.setElement(n2, rankedList.getScore(n));
            ++n2;
            --n;
        }
        arrayList.add(vector2);
        for (n2 = 0; n2 < dataset.getNumCol(); ++n2) {
            arrayList.add(dataset.getColumn(n2));
            arrayList.add(dataset2.getColumn(n2));
            arrayList2.add("Permuted pos " + Printf.format(fArray[n2] * 100.0f, 0) + "%");
            arrayList2.add("Permuted neg " + Printf.format(fArray[n2] * 100.0f, 0) + "%");
        }
        String string = null;
        String string2 = null;
        if (permutationTest.getTemplate().isCategorical()) {
            string = permutationTest.getTemplate().getClassName(0);
            string2 = permutationTest.getTemplate().getClassName(1);
        }
        return new XChartImpl("butterfly_plot", "Butterfly plot of significance", PermutationReports._createButterflyChart("Butterfly plot for: " + permutationTest.getName(), "Score (" + permutationTest.getMetric().getName() + ")", arrayList.toArray(new Vector[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), "Gene rank", vector, string, string2));
    }

    private static JFreeChart _createButterflyChart(String string, String string2, Vector[] vectorArray, String[] stringArray, String string3, Vector vector, String string4, String string5) {
        IntervalMarker intervalMarker;
        if (stringArray.length != vectorArray.length) {
            throw new IllegalArgumentException("Unequal lengths for xvectors: " + vectorArray.length + " and xlabels: " + stringArray);
        }
        XYSeries[] xYSeriesArray = new XYSeries[vectorArray.length];
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i2 = 0; i2 < vectorArray.length; ++i2) {
            xYSeriesArray[i2] = new XYSeries((Comparable)((Object)stringArray[i2]));
            for (int i3 = 0; i3 < vectorArray[i2].getSize(); ++i3) {
                xYSeriesArray[i2].add((double)vectorArray[i2].getElement(i3), vector.getElement(i3));
            }
            xYSeriesCollection.addSeries(xYSeriesArray[i2]);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.WHITE);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.WHITE);
        xYPlot.setDomainGridlinePaint(Color.GRAY);
        xYPlot.setRangeGridlinePaint(Color.GRAY);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setSeriesPaint(0, Color.RED);
        xYLineAndShapeRenderer.setSeriesPaint(1, Color.BLUE);
        xYLineAndShapeRenderer.setSeriesShape(0, PermutationReports.createCircleShape());
        xYLineAndShapeRenderer.setSeriesShape(1, PermutationReports.createCircleShape());
        xYLineAndShapeRenderer.setSeriesLinesVisible(0, false);
        xYLineAndShapeRenderer.setSeriesLinesVisible(1, false);
        ArrayList<Color> arrayList = new ArrayList<Color>(Arrays.asList(Color.BLACK, Color.PINK, Color.GREEN));
        int n = 0;
        for (int i4 = 2; i4 < xYSeriesArray.length; i4 += 2) {
            xYLineAndShapeRenderer.setSeriesShapesVisible(i4, false);
            xYLineAndShapeRenderer.setSeriesShapesVisible(i4 + 1, false);
            Paint paint = n < arrayList.size() ? (Color)arrayList.get(n) : xYLineAndShapeRenderer.getSeriesPaint(i4);
            xYLineAndShapeRenderer.setSeriesPaint(i4, paint);
            xYLineAndShapeRenderer.setSeriesPaint(i4 + 1, paint);
            ++n;
        }
        xYPlot.setRenderer(0, xYLineAndShapeRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        float f2 = vector.max() / 2.0f;
        if (string4 != null && string4.length() > 0) {
            intervalMarker = new IntervalMarker(f2, f2);
            intervalMarker.setLabel("'" + string4 + "' (Pos corr)");
            intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
            intervalMarker.setLabelAnchor(RectangleAnchor.RIGHT);
            intervalMarker.setLabelTextAnchor(TextAnchor.CENTER_RIGHT);
            intervalMarker.setLabelPaint(Color.RED);
            jFreeChart.getXYPlot().addRangeMarker(intervalMarker);
        }
        if (string5 != null && string5.length() > 0) {
            intervalMarker = new IntervalMarker(f2, f2);
            intervalMarker.setLabel("'" + string5 + "' (Neg corr)");
            intervalMarker.setLabelFont(new Font("SansSerif", 0, 10));
            intervalMarker.setLabelAnchor(RectangleAnchor.LEFT);
            intervalMarker.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
            intervalMarker.setLabelPaint(Color.BLUE);
            jFreeChart.getXYPlot().addRangeMarker(intervalMarker);
        }
        return jFreeChart;
    }

    public static final StringDataframe createSignificanceReport(PermutationTest permutationTest, Chip chip) {
        String string;
        String string2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(permutationTest.getNumMarkers() * 2);
        RankedList rankedList = permutationTest.getRankedList();
        float[] fArray = permutationTest.getSigLevels();
        Matrix matrix = permutationTest.getSigLevelsMatrix(true);
        Matrix matrix2 = permutationTest.getSigLevelsMatrix(false);
        boolean bl = permutationTest instanceof PermutationTestImpl;
        ArrayList<String> arrayList2 = new ArrayList<String>(fArray.length + 1);
        arrayList2.add("Gene");
        arrayList2.add("Title");
        arrayList2.add("Score");
        if (bl) {
            arrayList2.add(AlgMap.getMedianOrMeanLabel(permutationTest.getMetricParams()) + "0");
            arrayList2.add("stdev0");
            arrayList2.add(AlgMap.getMedianOrMeanLabel(permutationTest.getMetricParams()) + "1");
            arrayList2.add("stdev1");
        }
        int n2 = arrayList2.size();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            arrayList2.add("Sig at " + fArray[i2]);
        }
        StringMatrix stringMatrix = new StringMatrix(permutationTest.getNumMarkers() * 2, arrayList2.size());
        int n3 = 0;
        int n4 = 0;
        while (n4 < permutationTest.getNumMarkers()) {
            n = 0;
            String string3 = rankedList.getRankName(n4);
            string2 = "NULL";
            string = "NULL";
            if (chip != null) {
                string2 = chip.getSymbol(string3, Chip.OMIT_NULLS);
                string = chip.getSymbol(string3, Chip.OMIT_NULLS);
            }
            stringMatrix.setElement(n4, n++, string2);
            stringMatrix.setElement(n4, n++, string);
            stringMatrix.setElement(n4, n++, rankedList.getScore(n4));
            if (bl) {
                DatasetStatsCore$TwoClassMarkerStats datasetStatsCore$TwoClassMarkerStats = permutationTest.getScore(string3);
                stringMatrix.setElement(n4, n++, (float)datasetStatsCore$TwoClassMarkerStats.getMe0());
                stringMatrix.setElement(n4, n++, (float)datasetStatsCore$TwoClassMarkerStats.getStdev0());
                stringMatrix.setElement(n4, n++, (float)datasetStatsCore$TwoClassMarkerStats.getMe1());
                stringMatrix.setElement(n4, n, (float)datasetStatsCore$TwoClassMarkerStats.getStdev1());
            }
            for (int i3 = 0; i3 < fArray.length; ++i3) {
                stringMatrix.setElement(n4, i3 + n2, matrix.getElement(n4, i3));
            }
            arrayList.add(string3);
            ++n4;
            ++n3;
        }
        n4 = rankedList.getSize() - 1;
        n = 0;
        while (n < permutationTest.getNumMarkers()) {
            int n5 = 0;
            string2 = rankedList.getRankName(n4);
            string = "NULL";
            String string4 = "NULL";
            if (chip != null) {
                string = chip.getSymbol(string2, Chip.OMIT_NULLS);
                string4 = chip.getSymbol(string2, Chip.OMIT_NULLS);
            }
            stringMatrix.setElement(n3, n5++, string);
            stringMatrix.setElement(n3, n5++, string4);
            stringMatrix.setElement(n3, n5++, rankedList.getScore(n4));
            if (bl) {
                DatasetStatsCore$TwoClassMarkerStats datasetStatsCore$TwoClassMarkerStats = permutationTest.getScore(string2);
                stringMatrix.setElement(n3, n5++, (float)datasetStatsCore$TwoClassMarkerStats.getMe0());
                stringMatrix.setElement(n3, n5++, (float)datasetStatsCore$TwoClassMarkerStats.getStdev0());
                stringMatrix.setElement(n3, n5++, (float)datasetStatsCore$TwoClassMarkerStats.getMe1());
                stringMatrix.setElement(n3, n5, (float)datasetStatsCore$TwoClassMarkerStats.getStdev1());
            }
            for (int i4 = 0; i4 < fArray.length; ++i4) {
                stringMatrix.setElement(n3, i4 + n2, matrix2.getElement(n, i4));
            }
            arrayList.add(string2);
            ++n;
            --n4;
            ++n3;
        }
        return new StringDataframe("sig " + permutationTest.getName(), stringMatrix, arrayList, arrayList2, true);
    }
}

