/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.DataframeParser;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.PicFile;
import edu.mit.broad.genome.reports.pages.Page;
import java.io.File;
import java.io.OutputStream;

public class ExcelTxtPage
implements Page {
    private String fName;
    private IDataframe fIdf;

    public ExcelTxtPage(String string, IDataframe iDataframe) {
        if (iDataframe == null) {
            throw new IllegalArgumentException("Param idf cannot be null");
        }
        this.fIdf = iDataframe instanceof RichDataframe ? ((RichDataframe)iDataframe).getDataframe() : iDataframe;
        this.fName = string;
    }

    @Override
    public final String getName() {
        return this.fName;
    }

    @Override
    public final String getExt() {
        return "xls";
    }

    @Override
    public final String getDesc() {
        return this.fIdf.getComment();
    }

    @Override
    public final PicFile[] write(OutputStream outputStream, File file) {
        if (this.fIdf instanceof StringDataframe) {
            StringDataframeParser stringDataframeParser = new StringDataframeParser();
            stringDataframeParser.setSilentMode(true);
            stringDataframeParser.export((PersistentObject)this.fIdf, outputStream);
        } else if (this.fIdf instanceof Dataframe) {
            DataframeParser dataframeParser = new DataframeParser();
            dataframeParser.setSilentMode(true);
            dataframeParser.export((PersistentObject)this.fIdf, outputStream);
        } else {
            throw new NotImplementedException("idf object: " + this.fIdf);
        }
        return new PicFile[0];
    }
}

