/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import edu.mit.broad.genome.swing.AutoCompletion$1;
import edu.mit.broad.genome.swing.AutoCompletion$2;
import edu.mit.broad.genome.swing.AutoCompletion$3;
import edu.mit.broad.genome.swing.AutoCompletion$4;
import edu.mit.broad.genome.swing.AutoCompletion$5;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompletion
extends PlainDocument {
    JComboBox comboBox;
    ComboBoxModel model;
    JTextComponent editor;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoCompletion(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.model = jComboBox.getModel();
        jComboBox.addActionListener(new AutoCompletion$1(this));
        jComboBox.addPropertyChangeListener(new AutoCompletion$2(this));
        this.editorKeyListener = new AutoCompletion$3(this, jComboBox);
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new AutoCompletion$4(this, jComboBox);
        this.configureEditor(jComboBox.getEditor());
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        this.highlightCompletedText(0);
    }

    public static final void enable(JComboBox jComboBox) {
        jComboBox.setEditable(true);
        new AutoCompletion(jComboBox);
    }

    final void configureEditor(ComboBoxEditor comboBoxEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (comboBoxEditor != null) {
            this.editor = (JTextComponent)comboBoxEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public final void remove(int n, int n2) {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (n > 0) {
                if (this.hitBackspaceOnSelection) {
                    --n;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.highlightCompletedText(n);
        } else {
            super.remove(n, n2);
        }
    }

    @Override
    public final void insertString(int n, String string, AttributeSet attributeSet) {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        if (object != null) {
            this.setSelectedItem(object);
        } else {
            object = this.comboBox.getSelectedItem();
            n -= string.length();
            this.comboBox.getToolkit().beep();
        }
        this.setText(object.toString());
        this.highlightCompletedText(n + string.length());
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void highlightCompletedText(int n) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.model.setSelectedItem(object);
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        int n = this.model.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            Object e2 = this.model.getElementAt(i2);
            if (e2 == null || !this.startsWithIgnoreCase(e2.toString(), string)) continue;
            return e2;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    private static void createAndShowGUI() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        AutoCompletion.enable(jComboBox);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jComboBox);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static final void main(String[] stringArray) {
        SwingUtilities.invokeLater(new AutoCompletion$5());
    }

    static final /* synthetic */ void access$000(AutoCompletion autoCompletion, int n) {
        autoCompletion.highlightCompletedText(n);
    }

    static final /* synthetic */ void access$100() {
        AutoCompletion.createAndShowGUI();
    }
}

