/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private Image image = null;
    private boolean scaled = false;
    private Dimension size = null;
    private Insets insets = new Insets(0, 0, 0, 0);

    public ImageComponent(Image image, boolean bl) {
        this.image = image;
        this.scaled = bl;
    }

    public final void setImage(Image image) {
        this.image = image;
        this.revalidate();
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        this.insets = this.getInsets(this.insets);
        this.size = this.getSize(this.size);
        if (this.image == null) {
            return;
        }
        if (this.scaled) {
            graphics.drawImage(this.image, this.insets.left, this.insets.top, this.size.width - this.insets.left - this.insets.right, this.size.height - this.insets.top - this.insets.bottom, this);
        } else {
            graphics.drawImage(this.image, this.insets.left, this.insets.top, this);
        }
    }

    @Override
    public final Dimension getMinimumSize() {
        int n = 32;
        int n2 = 32;
        if (this.image != null) {
            n = this.image.getWidth(this);
            n2 = this.image.getHeight(this);
        }
        this.insets = this.getInsets(this.insets);
        return new Dimension(this.insets.left + Math.max(32, n / 10) + this.insets.right, this.insets.top + Math.max(32, n2 / 10) + this.insets.bottom);
    }

    @Override
    public final Dimension getPreferredSize() {
        int n = 32;
        int n2 = 32;
        if (this.image != null) {
            n = this.image.getWidth(this);
            n2 = this.image.getHeight(this);
        }
        this.insets = this.getInsets(this.insets);
        return new Dimension(this.insets.left + n + this.insets.right, this.insets.top + n2 + this.insets.bottom);
    }

    @Override
    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

