/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.dnd;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.dnd.DndSource;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import org.apache.log4j.Logger;

public class DragSourceDecorator
implements DragGestureListener,
DragSourceListener {
    private final Logger log = XLogger.getLogger(DragSourceDecorator.class);
    private DragSource fDragSource;
    private final int fDragAction = 3;
    private DndSource fSource;

    public DragSourceDecorator(DndSource dndSource) {
        if (dndSource == null) {
            throw new IllegalArgumentException("Param DndSource cannot be null");
        }
        this.fSource = dndSource;
        this.fDragSource = DragSource.getDefaultDragSource();
        if (this.fSource.getDraggableComponent() == null) {
            this.log.warn("Null draggable component for: " + this.fSource);
        }
        this.fDragSource.createDefaultDragGestureRecognizer(this.fSource.getDraggableComponent(), this.fDragAction, this);
    }

    @Override
    public final void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if ((dragGestureEvent.getDragAction() & 3) == 0) {
            return;
        }
        try {
            Transferable transferable = this.fSource.getTransferable();
            if (transferable != null) {
                dragGestureEvent.startDrag(DragSource.DefaultCopyNoDrop, transferable, this);
            }
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            this.log.error(invalidDnDOperationException);
        }
    }

    @Override
    public final void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & 3) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public final void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public final void dragExit(DragSourceEvent dragSourceEvent) {
        DragSourceContext dragSourceContext = dragSourceEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
    }
}

