/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.utils.CollectionUtils$EmptyEnum;
import edu.mit.broad.genome.utils.CollectionUtils$EmptyMap;
import edu.mit.broad.genome.utils.CollectionUtils$VoidMap;
import edu.mit.broad.genome.utils.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class CollectionUtils {
    private static final Logger klog = XLogger.getLogger(CollectionUtils.class);
    public static final Enumeration EMPTY_ENUMERATION = new CollectionUtils$EmptyEnum(null);
    public static final Map EMPTY_MAP = new CollectionUtils$EmptyMap(null);
    public static final Map VOID_MAP = new CollectionUtils$VoidMap(null);

    public static final void removeAll_case_insensitive(List list, List list2) {
        list.removeAll(CollectionUtils.findMatches_case_insensitive(list, list2));
    }

    public static final void removeAll_case_insensitive(Set set, Set set2) {
        set.removeAll(CollectionUtils.findMatches_case_insensitive(set, set2));
    }

    public static final Set findMatches_case_insensitive(Set set, Set set2) {
        return CollectionUtils.findMatches_case_insensitive(new ArrayList(set), new ArrayList(set2));
    }

    public static final Set findMatches_case_insensitive(List list, List list2) {
        List list3 = CollectionUtils.toUpperCase(list);
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            String string = list2.get(i2).toString().toUpperCase();
            if (!list3.contains(string)) continue;
            int n = list3.indexOf(string);
            hashSet.add(list.get(n));
        }
        return hashSet;
    }

    public static final List toUpperCase(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (e2 == null) continue;
            list.set(i2, e2.toString().toUpperCase());
        }
        return list;
    }

    public static final Set toUpperCase(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e2 : set) {
            hashSet.add(e2.toString().toUpperCase());
        }
        return hashSet;
    }

    public static final Set toLowerCase(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e2 : set) {
            hashSet.add(e2.toString().toLowerCase());
        }
        return hashSet;
    }

    public static final List toLowerCase(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object e2 = list.get(i2);
            if (e2 == null) continue;
            list.set(i2, e2.toString().toLowerCase());
        }
        return list;
    }

    public static final Set toSet(String[] stringArray) {
        if (stringArray == null) {
            return new HashSet();
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashSet.add(stringArray[i2]);
        }
        return hashSet;
    }

    public static final Map mergeStringValues(Map map, Map map2, String string) {
        StringBuffer stringBuffer;
        Object v;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap(map2);
        for (Object k2 : map.keySet()) {
            v = map.get(k2);
            stringBuffer = new StringBuffer();
            if (v != null) {
                stringBuffer.append(v.toString()).append(string);
            }
            if (hashMap2.containsKey(k2)) {
                Object v2 = hashMap2.get(k2);
                if (v2 != null) {
                    stringBuffer.append(v2.toString()).append(string);
                }
                hashMap2.remove(k2);
            }
            hashMap.put(k2, stringBuffer.toString());
        }
        for (Object k2 : hashMap2.keySet()) {
            v = hashMap2.get(k2);
            if (map.containsKey(k2)) {
                throw new IllegalStateException("Error - not possible key: " + k2);
            }
            stringBuffer = new StringBuffer();
            if (v != null) {
                stringBuffer = stringBuffer.append(v.toString()).append(string);
            }
            hashMap.put(k2, stringBuffer.toString());
        }
        CollectionUtils.trimStringValues(hashMap);
        return hashMap;
    }

    public static final void trimStringValues(Map map) {
        for (Object k2 : map.keySet()) {
            Object v = map.get(k2);
            if (v == null) continue;
            String string = v.toString();
            string = string.trim();
            map.put(k2, v);
        }
    }

    public static final List createSeriesStrings(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(n2 - n);
        for (int i2 = n; i2 < n2; ++i2) {
            arrayList.add(i2 + "");
        }
        return arrayList;
    }

    public static final List createSeriesStrings(int n, int n2, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(n2 - n);
        for (int i2 = n; i2 < n2; ++i2) {
            arrayList.add(string + i2);
        }
        return arrayList;
    }

    public static final String toStringTabDelimited(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append('\t');
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static final int size(Enumeration enumeration) {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    public static final int moveUp(Object object, List list) {
        int n = list.indexOf(object);
        if (n == -1) {
            throw new IllegalArgumentException("Specified object is not in the list obj=" + object);
        }
        if (n > 0) {
            Object e2 = list.get(n - 1);
            list.set(n - 1, object);
            list.set(n, e2);
        }
        return n - 1;
    }

    public static final int moveDown(Object object, List list) {
        int n = list.indexOf(object);
        if (n == -1) {
            throw new IllegalArgumentException("Specified object is not in the list obj=" + object);
        }
        if (n < list.size() - 1) {
            Object e2 = list.get(n + 1);
            list.set(n + 1, object);
            list.set(n, e2);
        }
        return n + 1;
    }

    public static final void printf(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stringBuffer.append(list.get(i2)).append(", ");
            if (i2 == 0 || i2 % 10 != 0) continue;
            stringBuffer.append("\n");
        }
        System.out.println("----- Number of elements=" + list.size());
        System.out.println(stringBuffer.toString());
    }

    public static final Collection union(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        for (Object e2 : hashSet) {
            int n = Math.max(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2));
            for (int i2 = 0; i2 < n; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static final Set unionSet(Collection[] collectionArray) {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < collectionArray.length; ++i2) {
            hashSet.addAll(collectionArray[i2]);
        }
        return hashSet;
    }

    public static final Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        for (Object e2 : hashSet) {
            int n = Math.min(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2));
            for (int i2 = 0; i2 < n; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static final Collection disjunction(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        for (Object e2 : hashSet) {
            int n = Math.max(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2)) - Math.min(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2));
            for (int i2 = 0; i2 < n; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static final Collection subtract(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static final Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        for (Object e2 : collection) {
            Integer n = (Integer)hashMap.get(e2);
            if (null == n) {
                hashMap.put(e2, new Integer(1));
                continue;
            }
            hashMap.put(e2, new Integer(n + 1));
        }
        return hashMap;
    }

    public static final boolean isSubCollection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        for (Object e2 : collection) {
            if (CollectionUtils.getFreq(e2, map) <= CollectionUtils.getFreq(e2, map2)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isProperSubCollection(Collection collection, Collection collection2) {
        return CollectionUtils.isSubCollection(collection, collection2) && !CollectionUtils.isEqualCollection(collection, collection2);
    }

    public static final boolean isEqualCollection(Collection collection, Collection collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        if (map.size() != map2.size()) {
            return false;
        }
        for (Object k2 : map.keySet()) {
            if (CollectionUtils.getFreq(k2, map) == CollectionUtils.getFreq(k2, map2)) continue;
            return false;
        }
        return true;
    }

    public static final int cardinality(Object object, Collection collection) {
        int n = 0;
        for (Object e2 : collection) {
            if ((null != object || null != e2) && !object.equals(e2)) continue;
            ++n;
        }
        return n;
    }

    public static final Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            for (Object e2 : collection) {
                if (!predicate.evaluate(e2)) continue;
                return e2;
            }
        }
        return null;
    }

    public static final Collection select(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.select(collection, predicate, arrayList);
        return arrayList;
    }

    public static final void select(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            for (Object e2 : collection) {
                if (!predicate.evaluate(e2)) continue;
                collection2.add(e2);
            }
        }
    }

    public static final void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static final void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static final void addAll(Collection collection, Object[] objectArray) {
        int n = objectArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            collection.add(objectArray[i2]);
        }
    }

    private static final int getFreq(Object object, Map map) {
        try {
            return (Integer)map.get(object);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return 0;
    }

    public static final Collection findCommon(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet();
        for (Object e2 : collection2) {
            if (!collection.contains(e2)) continue;
            hashSet.add(e2);
        }
        return hashSet;
    }

    public static final Set findCommon(Set set, Set set2) {
        return (Set)CollectionUtils.findCommon((Collection)set, (Collection)set2);
    }

    public static final int findNumCommon(Set set, Set set2) {
        int n = 0;
        for (Object e2 : set2) {
            if (!set.contains(e2)) continue;
            ++n;
        }
        return n;
    }
}

