/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.Chip2ChipMapperSlimJit;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class VdbRuntimeResources$MappedChipWrapper
implements Serializable {
    private Object fMapFileOrC2C;

    private VdbRuntimeResources$MappedChipWrapper(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Param mapFileOrC2C cannot be null");
        }
        if (!(object instanceof File) && !(object instanceof Chip2ChipMapper)) {
            throw new IllegalArgumentException("Unexpected object type: " + object);
        }
        this.fMapFileOrC2C = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        throw new NotImplementedException("out: " + objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new NotImplementedException("in: " + objectInputStream);
    }

    private Chip2ChipMapper createMappedChip() {
        if (this.fMapFileOrC2C instanceof Chip2ChipMapper) {
            return (Chip2ChipMapper)this.fMapFileOrC2C;
        }
        File file = (File)this.fMapFileOrC2C;
        if (!file.exists()) {
            VdbRuntimeResources.access$000().info("Chipping in symbol 2 symbol mode: " + file);
            String[] stringArray = ParseUtils.string2strings(file.getName(), ".", false);
            if (stringArray.length != 3) {
                throw new IllegalStateException("Expected 3 fields, got: " + stringArray.length + " so unknown mapping db: " + file);
            }
            if (!stringArray[2].equalsIgnoreCase("GENE_SYMBOL")) {
                throw new IllegalStateException("Expected: Gene_Symbol");
            }
            Chip chip = VdbRuntimeResources.getChip(stringArray[0]);
            Chip chip2 = VdbRuntimeResources.getChip(stringArray[1]);
            return new Chip2ChipMapperSymbol(chip, chip2);
        }
        return new Chip2ChipMapperSlimJit(file);
    }

    public String toString() {
        if (this.fMapFileOrC2C instanceof Chip2ChipMapper) {
            return ((Chip2ChipMapper)this.fMapFileOrC2C).getName();
        }
        return FileUtils.removeExtension((File)this.fMapFileOrC2C);
    }

    public String getPath() {
        if (this.fMapFileOrC2C instanceof Chip2ChipMapper) {
            return ((Chip2ChipMapper)this.fMapFileOrC2C).getName();
        }
        return ((File)this.fMapFileOrC2C).getPath();
    }

    public int hashCode() {
        return this.fMapFileOrC2C.hashCode();
    }

    public boolean equals(Object object) {
        if (this.fMapFileOrC2C instanceof Chip2ChipMapper) {
            Chip2ChipMapper chip2ChipMapper = (Chip2ChipMapper)this.fMapFileOrC2C;
            return chip2ChipMapper.equals(object);
        }
        File file = (File)this.fMapFileOrC2C;
        return file.equals(object);
    }
}

