/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.vdb.chip.AbstractChip;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileInMemoryChip
extends AbstractChip {
    private Probe[] fProbes;
    private THashMap fSymbolProbeNameSetMap;
    private Map fProbeNameProbeMap;
    private boolean fDeepDataInited = false;
    private Chip[] fMadeFromChips_lazy;

    public FileInMemoryChip(String string, String string2) {
        super(string, string2);
    }

    public FileInMemoryChip(String string, String string2, Probe[] probeArray) {
        this.initHere(string, string2, probeArray);
        this.fDeepDataInited = true;
    }

    protected FileInMemoryChip(Chip[] chipArray) {
        super(FileInMemoryChip._createComboName(chipArray), "combo_dummy_source");
        if (chipArray == null) {
            throw new IllegalArgumentException("Param chips cannot be null");
        }
        for (int i2 = 0; i2 < chipArray.length; ++i2) {
            if (chipArray[i2] != null) continue;
            throw new IllegalArgumentException("Param chips cannot be null at index: " + i2);
        }
        this.fMadeFromChips_lazy = chipArray;
    }

    private void initHere(String string, String string2, Probe[] probeArray) {
        if (!this.isInited()) {
            super.initialize(string);
        }
        if (!NamingConventions.isURL(string2)) {
            boolean bl = false;
            if (string2 == null) {
                bl = true;
            } else if (!new File(string2).exists()) {
                bl = true;
            } else if (!string2.equals("combo_dummy_source")) {
                bl = true;
            }
            if (bl) {
                this.log.warn("Missing chip file: >" + string2 + "<");
            }
        }
        if (probeArray == null) {
            throw new IllegalArgumentException("Param probes cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Param chipName cannot be null");
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        this.fProbes = new Probe[probeArray.length];
        for (int i2 = 0; i2 < probeArray.length; ++i2) {
            this.fProbes[i2] = probeArray[i2];
            if (hashSet.contains(probeArray[i2].getName())) {
                hashSet2.add(probeArray[i2].getName());
            }
            hashSet.add(probeArray[i2].getName());
        }
        if (!hashSet2.isEmpty()) {
            this.log.debug("There were duplicate probes: " + hashSet2.size() + "\n" + hashSet2 + "\n" + this.getName());
        } else {
            this.log.debug("There were no duplicates: " + hashSet.size() + " " + this.getName());
        }
        hashSet.clear();
        hashSet2.clear();
        this.fSourcePath = string2;
    }

    private void readDeepData() {
        if (this.fDeepDataInited) {
            return;
        }
        if (this.fMadeFromChips_lazy != null) {
            HashSet<Probe> hashSet = new HashSet<Probe>();
            for (int i2 = 0; i2 < this.fMadeFromChips_lazy.length; ++i2) {
                Probe[] probeArray = this.fMadeFromChips_lazy[i2].getProbes();
                for (int i3 = 0; i3 < probeArray.length; ++i3) {
                    Probe probe = probeArray[i3];
                    hashSet.add(probe);
                }
            }
            this.initHere(FileInMemoryChip._createComboName(this.fMadeFromChips_lazy), "combo_dummy_source", hashSet.toArray(new Probe[hashSet.size()]));
            this.fDeepDataInited = true;
            return;
        }
        try {
            FileInMemoryChip fileInMemoryChip = (FileInMemoryChip)ParserFactory.readChip(this.fSourcePath, true);
            this.initHere(fileInMemoryChip.getName(), this.fSourcePath, fileInMemoryChip.fProbes);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Exception(throwable);
        }
        finally {
            this.fDeepDataInited = true;
        }
    }

    @Override
    public final String getQuickInfo() {
        if (this.fDeepDataInited) {
            return this.fProbes.length + " probes";
        }
        return null;
    }

    @Override
    public final int getNumProbes() {
        this.readDeepData();
        return this.fProbes.length;
    }

    @Override
    public final Probe getProbe(int n) {
        this.readDeepData();
        return this.fProbes[n];
    }

    @Override
    public final String getProbeName(int n) {
        this.readDeepData();
        return this.fProbes[n].getName();
    }

    @Override
    public final Probe[] getProbes() {
        this.readDeepData();
        Probe[] probeArray = new Probe[this.fProbes.length];
        for (int i2 = 0; i2 < this.fProbes.length; ++i2) {
            probeArray[i2] = this.fProbes[i2];
        }
        return probeArray;
    }

    protected final void initProbeProbeMap() {
        if (this.fProbeNameProbeMap == null) {
            this.readDeepData();
            this.fProbeNameProbeMap = new HashMap();
            for (int i2 = 0; i2 < this.fProbes.length; ++i2) {
                this.fProbeNameProbeMap.put(this.fProbes[i2].getName().toUpperCase(), this.fProbes[i2]);
            }
        }
    }

    @Override
    public final Set getProbeNames() {
        this.initProbeProbeMap();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumProbes(); ++i2) {
            hashSet.add(this.getProbe(i2).getName());
        }
        return hashSet;
    }

    @Override
    public final boolean isProbe(String string) {
        if (string == null) {
            return false;
        }
        this.initProbeProbeMap();
        string = string.toUpperCase();
        return this.fProbeNameProbeMap.containsKey(string);
    }

    @Override
    public final Probe getProbe(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param probeName cannot be null");
        }
        this.initProbeProbeMap();
        String string2 = string.toUpperCase();
        Object v = this.fProbeNameProbeMap.get(string2);
        if (v == null) {
            throw new IllegalArgumentException("No Probe called: " + string + " on this chip (chip name is >" + this.getName() + "<)");
        }
        return (Probe)v;
    }

    private void initSymbolMap() {
        if (this.fSymbolProbeNameSetMap == null) {
            this.readDeepData();
            this.fSymbolProbeNameSetMap = new THashMap();
            for (int i2 = 0; i2 < this.fProbes.length; ++i2) {
                Gene gene = this.fProbes[i2].getGene();
                if (gene == null) continue;
                String string = gene.getSymbol();
                HashSet hashSet = this.fSymbolProbeNameSetMap.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                ((Set)hashSet).add(this.fProbes[i2].getName());
                this.fSymbolProbeNameSetMap.put(string, hashSet);
            }
        }
    }

    @Override
    public final Set getProbeNames(Set set) {
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set2 = this.getProbeNames(iterator.next().toString());
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    @Override
    public final Set getProbeNames(String string) {
        this.initSymbolMap();
        Object object = this.fSymbolProbeNameSetMap.get(string);
        if (object == null) {
            return Collections.EMPTY_SET;
        }
        return (Set)object;
    }

    private static String _createComboName(Chip[] chipArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < chipArray.length; ++i2) {
            stringBuffer.append(chipArray[i2].getName());
            if (i2 == chipArray.length - 1) continue;
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }
}

