/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.MGeneSet;
import edu.mit.broad.vdb.map.MGeneSetImpl;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import edu.mit.broad.vdb.map.MGeneSetMatrixImpl;
import edu.mit.broad.vdb.map.MapUtils;
import edu.mit.broad.vdb.map.MappingDbType;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Set;

abstract class Chip2ChipMapperAbstract
implements Chip2ChipMapper {
    private static final long serialVersionUID = 3328221101996725699L;
    private THashMap fSourceProbeTargetProbesMap;
    private MappingDbType fMappingDbType;
    private String fSourceChipName;
    private String fTargetChipName;
    private String fName;

    Chip2ChipMapperAbstract() {
    }

    protected final void init(Chip2ChipMapper chip2ChipMapper) {
        Chip2ChipMapperAbstract chip2ChipMapperAbstract = (Chip2ChipMapperAbstract)chip2ChipMapper;
        this.init(chip2ChipMapperAbstract.fSourceChipName, chip2ChipMapperAbstract.fTargetChipName, chip2ChipMapperAbstract.fMappingDbType, chip2ChipMapperAbstract.fSourceProbeTargetProbesMap);
    }

    protected final void init(String string, String string2, MappingDbType mappingDbType, THashMap tHashMap) {
        if (string == null) {
            throw new IllegalArgumentException("Param sourceChipName cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Param targetChipName cannot be null");
        }
        if (mappingDbType == null) {
            throw new IllegalArgumentException("Param db cannot be null");
        }
        this.fSourceChipName = string;
        this.fTargetChipName = string2;
        this.fMappingDbType = mappingDbType;
        this.fSourceProbeTargetProbesMap = tHashMap;
        this.fName = MapUtils.createId(this.fSourceChipName, this.fTargetChipName, this.fMappingDbType);
    }

    @Override
    public String getNameEnglish() {
        return null;
    }

    protected abstract void checkAndInit();

    @Override
    public String getChipsId() {
        return MapUtils.createId(this.getSourceChip().getName(), this.getTargetChip().getName());
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public MGeneSet map(GeneSet geneSet, boolean bl) {
        return new MGeneSetImpl(geneSet, bl, this.getSourceChip().getName(), this.getTargetChip().getName(), this.getMappingDbType(), this);
    }

    @Override
    public MGeneSetMatrix map(GeneSetMatrix geneSetMatrix, boolean bl) {
        return new MGeneSetMatrixImpl(geneSetMatrix, bl, this.getSourceChip().getName(), this.getTargetChip().getName(), this.getMappingDbType(), this);
    }

    @Override
    public Set map(String string) {
        Object object = this.fSourceProbeTargetProbesMap.get(string);
        if (object == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet((Set)object);
    }

    @Override
    public String[] getSourceProbes() {
        return this.fSourceProbeTargetProbesMap.keySet().toArray(new String[this.fSourceProbeTargetProbesMap.size()]);
    }

    @Override
    public MappingDbType getMappingDbType() {
        return this.fMappingDbType;
    }

    @Override
    public Chip getSourceChip() {
        return VdbRuntimeResources.getChip(this.fSourceChipName);
    }

    @Override
    public Chip getTargetChip() {
        return VdbRuntimeResources.getChip(this.fTargetChipName);
    }

    @Override
    public int getNumSourceProbes() {
        return this.fSourceProbeTargetProbesMap.size();
    }

    @Override
    public boolean equals(Chip chip, Chip chip2, MappingDbType mappingDbType) {
        return MapUtils.equals(chip, chip2, mappingDbType, this.getSourceChip(), this.getTargetChip(), this.getMappingDbType().getName());
    }

    @Override
    public boolean equals(Chip chip, Chip chip2) {
        return MapUtils.equals(chip, chip2, this.getSourceChip(), this.getTargetChip());
    }

    @Override
    public Id getId() {
        return null;
    }

    @Override
    public String getComment() {
        return "";
    }

    @Override
    public void addComment(String string) {
    }

    @Override
    public boolean hasProperty(String string) {
        return false;
    }

    @Override
    public String getProperty(String string) {
        return null;
    }

    @Override
    public void setProperty(String string, String string2) {
    }
}

