/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.vdb.meg.Gene$Helper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultGene
implements Gene {
    private String fSymbol;
    private String fTitle;
    protected String fCyto_opt;
    private Set fAliases;
    protected Set fSeqAccessions;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public DefaultGene() {
    }

    @Override
    public Gene cloneDeep() {
        DefaultGene defaultGene = new DefaultGene();
        defaultGene.fSymbol = this.fSymbol;
        defaultGene.fTitle = this.fTitle;
        defaultGene.fAliases = new HashSet(this.fAliases);
        defaultGene.fSeqAccessions = new HashSet(this.fSeqAccessions);
        return defaultGene;
    }

    public DefaultGene(String string, String string2, Set set, String string3, Set set2) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter symbol cannot be null");
        }
        this.fTitle = NamingConventions.titleize(string2);
        this.fSymbol = string.toUpperCase();
        if (set != null) {
            this.fAliases = Collections.unmodifiableSet(set);
        }
        if (set2 != null) {
            this.fSeqAccessions = Collections.unmodifiableSet(set2);
        }
        if (string3 != null) {
            this.fCyto_opt = NamingConventions.parseCyto(string3);
        }
    }

    @Override
    public String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getCyto() {
        return this.fCyto_opt;
    }

    @Override
    public String getTitle_truncated() {
        return Gene$Helper.getTitle_truncated(this.fTitle);
    }

    @Override
    public Set getAliases() {
        if (this.fAliases == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.fAliases);
    }

    @Override
    public String[] getAliasesArray() {
        Set set = this.getAliases();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Set getSeqAccessions() {
        if (this.fSeqAccessions == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.fSeqAccessions);
    }

    @Override
    public boolean containsAlias(String string) {
        return this.fAliases != null && this.fAliases.contains(string);
    }

    @Override
    public boolean containsSeqAccession(String string) {
        return this.fSeqAccessions != null && this.fSeqAccessions.contains(string);
    }

    public final boolean equals(Object object) {
        return object instanceof Gene && ((Gene)object).getSymbol().equalsIgnoreCase(this.getSymbol());
    }

    public final String toString() {
        return this.getSymbol();
    }

    public final int hashCode() {
        return this.getSymbol().hashCode();
    }
}

