/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.utils.Strings;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.sampledb.Sample;
import edu.mit.broad.vdb.sampledb.SampleDataSource;

public abstract class AbstractSample
implements Sample {
    public String fCelFileName;
    protected String fSampleName;
    protected SampleDataSource fDataSource;
    protected String fChipName;
    protected String fOrganism;
    protected float fPCall;
    protected boolean fQuality;
    protected String fComments;
    protected static final String COMMA = ",";
    protected static final String EMPTY = "";

    @Override
    public String getCategoryValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param categoryName cannot be null");
        }
        if (string.equalsIgnoreCase("PLATFORM")) {
            return this.getChipName();
        }
        if (string.equalsIgnoreCase("SAMPLE_NAME")) {
            return this.getName();
        }
        if (string.equalsIgnoreCase("ORGANISM")) {
            return this.getOrganism();
        }
        if (string.equalsIgnoreCase("COMMENTS")) {
            return this.getComments();
        }
        if (string.equalsIgnoreCase("%_P_CALLS_ON_ARRAY")) {
            return this.getPCall() + EMPTY;
        }
        if (string.equalsIgnoreCase("GOOD_QUALITY")) {
            return this.getQuality() + EMPTY;
        }
        if (string.equalsIgnoreCase("SOURCE_OF_DATA")) {
            return this.getDataSource().getName();
        }
        return null;
    }

    public static final void setCommonSampleProperties(AbstractSample[] abstractSampleArray, StringDataframe stringDataframe) {
        String[] stringArray = stringDataframe.getColumn("SAMPLE_NAME");
        for (int i2 = 0; i2 < abstractSampleArray.length; ++i2) {
            abstractSampleArray[i2].fSampleName = stringArray[i2].toUpperCase();
        }
        String[] stringArray2 = stringDataframe.getColumn("SOURCE_OF_DATA");
        for (int i3 = 0; i3 < abstractSampleArray.length; ++i3) {
            abstractSampleArray[i3].fDataSource = SampleDataSource.lookup(stringArray2[i3]);
        }
        String[] stringArray3 = stringDataframe.getColumn("PLATFORM");
        for (int i4 = 0; i4 < abstractSampleArray.length; ++i4) {
            abstractSampleArray[i4].fChipName = VdbRuntimeResources.geo2affy_chip_convert(stringArray3[i4]);
        }
        String[] stringArray4 = stringDataframe.getColumn("ORGANISM");
        for (int i5 = 0; i5 < abstractSampleArray.length; ++i5) {
            abstractSampleArray[i5].fOrganism = stringArray4[i5];
        }
        String[] stringArray5 = stringDataframe.getColumn("%_P_CALLS_ON_ARRAY");
        for (int i6 = 0; i6 < abstractSampleArray.length; ++i6) {
            abstractSampleArray[i6].fPCall = stringArray5[i6].equalsIgnoreCase("na") ? Float.NaN : AbstractSample._float(stringArray5[i6]);
        }
        String[] stringArray6 = stringDataframe.getColumn("GOOD_QUALITY");
        for (int i7 = 0; i7 < abstractSampleArray.length; ++i7) {
            abstractSampleArray[i7].fQuality = AbstractSample.lookupQuality(stringArray6[i7]);
        }
        String[] stringArray7 = stringDataframe.getColumn("COMMENTS");
        for (int i8 = 0; i8 < abstractSampleArray.length; ++i8) {
            abstractSampleArray[i8].fComments = stringArray7[i8];
        }
    }

    public static final float _float(String string) {
        String string2 = Strings.replace(string, COMMA, EMPTY);
        return Float.parseFloat(string2);
    }

    public static final boolean lookupQuality(String string) {
        return string == null || !string.toUpperCase().startsWith("N");
    }

    @Override
    public Chip getChip() {
        return VdbRuntimeResources.getChip(this.getChipName());
    }

    @Override
    public String getCelFileName() {
        return this.fCelFileName;
    }

    @Override
    public String getChipName() {
        return this.fChipName;
    }

    @Override
    public String getName() {
        return this.fSampleName;
    }

    @Override
    public SampleDataSource getDataSource() {
        return this.fDataSource;
    }

    @Override
    public String getOrganism() {
        return this.fOrganism;
    }

    @Override
    public float getPCall() {
        return this.fPCall;
    }

    @Override
    public boolean getQuality() {
        return this.fQuality;
    }

    @Override
    public String getComments() {
        return this.fComments;
    }

    @Override
    public String getPCall_str() {
        float f2 = this.getPCall();
        if (f2 < 20.0f) {
            return "<20";
        }
        if (f2 < 30.0f) {
            return "20<=>30";
        }
        if (f2 < 40.0f) {
            return "30<=>40";
        }
        if (f2 > 60.0f) {
            return ">60";
        }
        return "40<=>60";
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final String toString() {
        return this.getName();
    }

    public final boolean equals(Object object) {
        throw new NotImplementedException();
    }
}

