/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.vdb.sampledb.State;
import edu.mit.broad.vdb.sampledb.StateExpression;

public class StateExpressionImpl
implements StateExpression {
    public State fState;
    public Dataset fStateDs;

    public StateExpressionImpl(State state, Dataset dataset) {
        this.fState = state;
        this.fStateDs = dataset;
    }

    @Override
    public final State getState() {
        return this.fState;
    }

    @Override
    public final Dataset getDataset() {
        return this.fStateDs;
    }

    @Override
    public final double getMeanOrMedianValue(String string, boolean bl) {
        return this.getDataset().getRow(string).meanOrMedian(bl);
    }

    @Override
    public final float calcPCallFrac(DefaultDataset defaultDataset, String string) {
        APMMatrix aPMMatrix = defaultDataset.getAPMMatrix();
        int n = defaultDataset.getRowIndex(string);
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.fStateDs.getNumCol(); ++i2) {
            String string2 = this.fStateDs.getColumnName(i2);
            int n2 = defaultDataset.getColumnIndex(string2);
            if (!aPMMatrix.isPresent(n, n2)) continue;
            f2 += 1.0f;
        }
        return f2 / (float)this.fStateDs.getNumCol();
    }

    @Override
    public final float calcExpressionFrac(float f2, String string) {
        Vector vector = this.fStateDs.getRow(string);
        float f3 = 0.0f;
        for (int i2 = 0; i2 < vector.getSize(); ++i2) {
            if (!(vector.getElement(i2) >= f2)) continue;
            f3 += 1.0f;
        }
        return f3 / (float)vector.getSize();
    }

    @Override
    public final float calcExpressionMean(String string, boolean bl) {
        return (float)this.fStateDs.getRow(string).meanOrMedian(bl);
    }
}

