/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import javax.swing.Icon;

public class GeneSetMatrix2GeneSetsAction
extends FileObjectAction {
    private Object fFileOrObject;

    public GeneSetMatrix2GeneSetsAction() {
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
    }

    @Override
    public final void setFile(File file) {
        this.fFileOrObject = file;
    }

    @Override
    public final void setObject(Object object) {
        this.fFileOrObject = object;
    }

    @Override
    public final Widget getWidget() {
        Widget widget = null;
        try {
            if (this.fFileOrObject != null) {
                GeneSetMatrix geneSetMatrix;
                if (this.fFileOrObject instanceof File) {
                    geneSetMatrix = (GeneSetMatrix)ParserFactory.read((File)this.fFileOrObject);
                } else if (this.fFileOrObject instanceof GeneSetMatrix) {
                    geneSetMatrix = (GeneSetMatrix)this.fFileOrObject;
                } else {
                    throw new IllegalArgumentException("Only GeneSetMatrix or File Objects allowed. Got: " + this.fFileOrObject);
                }
                ParserFactory.extractGeneSets(geneSetMatrix);
                Application.getWindowManager().showMessage("Successfully created a GeneSet from the Dataset " + geneSetMatrix.getName() + " into: " + geneSetMatrix.getNumGeneSets() + " gene sets");
            } else {
                Application.getWindowManager().showMessage("No file or object to work on was specified");
            }
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Error creating GeneSets from GeneSetMatrix", throwable);
        }
        return widget;
    }

    @Override
    public final String getId() {
        return "GeneSetMatrix2GeneSetsAction";
    }

    @Override
    public final String getName() {
        return "=> Extract GeneSets from the GeneSetMatrix";
    }

    @Override
    public final Icon getIcon() {
        return null;
    }

    @Override
    public final String getDescription() {
        return "Extract the GeneSets from the GeneSetMatrix";
    }
}

