/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.dialog.StandardDialogPane;
import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.ErrorWidgetJide2$1;
import edu.mit.broad.xbench.core.ErrorWidgetJide2$2;
import edu.mit.broad.xbench.core.ErrorWidgetJide2$3;
import edu.mit.broad.xbench.core.ErrorWidgetJide2$4;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import xtools.api.param.MissingReqdParamException;

public class ErrorWidgetJide2
extends StandardDialog {
    private JComponent _detailsPanel;
    private Throwable[] fErrors;
    private String fError_msg;
    private Logger log = XLogger.getLogger(ErrorWidgetJide2.class);

    public ErrorWidgetJide2(Frame frame, String string, Throwable throwable, String string2) {
        super(frame, ErrorWidgetJide2._title(string));
        Throwable[] throwableArray = null;
        if (throwable != null) {
            throwableArray = new Throwable[]{throwable};
        }
        this.init(string, throwableArray, string2);
    }

    public ErrorWidgetJide2(Frame frame, Errors errors) {
        super(frame, ErrorWidgetJide2._title(errors.getName()));
        this.init(errors.getName(), errors.getErrors(), errors.getErrors(false));
    }

    public ErrorWidgetJide2(Frame frame, String string) {
        super(frame, ErrorWidgetJide2._title(string));
        this.init(string, null, string);
    }

    private static String _title(String string) {
        if (string != null && string.length() > 80) {
            return "Error: " + string.substring(0, 80);
        }
        if (string != null) {
            return "Error: " + string;
        }
        return "Error";
    }

    private void init(String string, Throwable[] throwableArray, String string2) {
        boolean bl = false;
        if (string2 == null && throwableArray != null && throwableArray.length > 0 && throwableArray[0] != null) {
            string2 = throwableArray[0].getMessage();
            Throwable throwable = throwableArray[0];
            Throwable throwable2 = throwable.getCause();
            if (throwable instanceof MissingReqdParamException) {
                string2 = ((MissingReqdParamException)throwable).getMessageLongInHtml();
                bl = true;
            } else if (throwable2 instanceof MissingReqdParamException) {
                string2 = ((MissingReqdParamException)throwable2).getMessageLongInHtml();
                bl = true;
            }
        }
        this.fError_msg = string2 != null && string2.length() > 80 && !bl ? string2.substring(0, 80) + " ..." : string2;
        this.fErrors = throwableArray;
    }

    @Override
    public final JComponent createBannerPanel() {
        return null;
    }

    public final JComponent createDetailsPanel() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setColumns(80);
        jTextArea.setRows(20);
        jTextArea.setCaretPosition(0);
        StringBuffer stringBuffer = new StringBuffer("<Error Details>\n\n");
        stringBuffer.append("---- Full Error Message ----\n");
        if (this.fError_msg != null) {
            stringBuffer.append(this.fError_msg);
        } else {
            stringBuffer.append("na");
        }
        stringBuffer.append("\n\n");
        stringBuffer.append("---- Stack Trace ----\n");
        stringBuffer.append(TraceUtils.getAsString(this.fErrors));
        JLabel jLabel = new JLabel("Details:");
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setEditable(false);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Copy");
        jPanel.add(jButton);
        jButton.addActionListener(new ErrorWidgetJide2$1(this, jTextArea));
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 6));
        jPanel2.add((Component)new JScrollPane(jTextArea), "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.add((Component)jLabel, "First");
        jLabel.setLabelFor(jTextArea);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return jPanel2;
    }

    @Override
    protected final StandardDialogPane createStandardDialogPane() {
        return new ErrorWidgetJide2$2(this);
    }

    @Override
    public final JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 40, 40, 40));
        JLabel jLabel = this.fError_msg != null ? new JLabel(this.fError_msg) : new JLabel("There was an error. Click the details button for more information.");
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    @Override
    public final ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        jButton2.setMnemonic('D');
        jButton.setName("OK");
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "ALTERNATIVE");
        jButton.setAction(new ErrorWidgetJide2$3(this, "Close"));
        if (this.fErrors != null) {
            Action action = null;
            for (int i2 = 0; i2 < this.fErrors.length; ++i2) {
                if (!(this.fErrors[i2] instanceof StandardException)) continue;
                action = JarResources.createHelpAction((StandardException)this.fErrors[i2]);
            }
            if (action != null) {
                JButton jButton3 = new JButton("Help");
                jButton3.setAction(action);
                buttonPanel.addButton((AbstractButton)jButton3, "HELP");
            }
        }
        jButton2.setAction(new ErrorWidgetJide2$4(this, "Details >>"));
        this.setDefaultCancelAction(jButton.getAction());
        this.setDefaultAction(jButton.getAction());
        this.getRootPane().setDefaultButton(jButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return buttonPanel;
    }

    static final /* synthetic */ JComponent access$002(ErrorWidgetJide2 errorWidgetJide2, JComponent jComponent) {
        errorWidgetJide2._detailsPanel = jComponent;
        return errorWidgetJide2._detailsPanel;
    }

    static final /* synthetic */ JComponent access$000(ErrorWidgetJide2 errorWidgetJide2) {
        return errorWidgetJide2._detailsPanel;
    }
}

