/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.StatusBar;
import edu.mit.broad.xbench.core.api.Application$Handler;
import edu.mit.broad.xbench.core.api.FileManager;
import edu.mit.broad.xbench.core.api.ToolManager;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.core.api.WindowManager;
import java.awt.Dimension;
import org.apache.log4j.Logger;

public class Application {
    private static final Logger klog = XLogger.getLogger(Application.class);
    private static Application$Handler kAppHandler;
    public static Dimension DEFAULT_MODAL_WIDGET_RUNNER_DIALOG;

    private Application() {
    }

    public static final boolean isHandlerSet() {
        return kAppHandler != null;
    }

    public static final void registerHandler(Application$Handler application$Handler) {
        if (application$Handler == null) {
            throw new IllegalArgumentException("Param appHandler cannot be null");
        }
        kAppHandler = application$Handler;
        if (application$Handler.getStatusBar() != null) {
            XLogger.addAppender(application$Handler.getStatusBar());
        }
    }

    public static final boolean hasRegisteredHandler() {
        return kAppHandler != null;
    }

    private static void _check() {
        if (kAppHandler == null) {
            TraceUtils.showTrace();
            throw new IllegalStateException("No Application handler set yet: " + kAppHandler);
        }
    }

    public static final String getName() {
        Application._check();
        return kAppHandler.getName();
    }

    public static final boolean isFirstExecutionOfNewVersion() {
        Application._check();
        return kAppHandler.isFirstExecutionOfNewVersion();
    }

    public static final ToolManager getToolManager() {
        Application._check();
        return kAppHandler.getToolManager();
    }

    public static final FileManager getFileManager() {
        Application._check();
        return kAppHandler.getFileManager();
    }

    public static final VdbManager getVdbManager() {
        Application._check();
        return kAppHandler.getVdbManager();
    }

    public static final StatusBar getStatusBar() {
        Application._check();
        return kAppHandler.getStatusBar();
    }

    public static final WindowManager getWindowManager() {
        Application._check();
        return kAppHandler.getWindowManager();
    }

    static {
        DEFAULT_MODAL_WIDGET_RUNNER_DIALOG = new Dimension(575, 500);
    }
}

