/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.tui.TaskManager$Editor;
import edu.mit.broad.xbench.tui.TaskManager$Model;
import edu.mit.broad.xbench.tui.TaskManager$Renderer;
import edu.mit.broad.xbench.tui.TaskManager$ToolRunnable;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.param.ParamSet;

public class TaskManager {
    private static final Logger klog = XLogger.getLogger(TaskManager.class);
    private static final String[] COL_HEADERS = new String[]{" ", "Name", "Status"};
    private static final int COL_NUM = 0;
    private static final int COL_NAME = 1;
    private static final int COL_STATUS = 2;
    private final TaskManager$Model fModel;
    private JTable fTaskTable;
    private boolean fOnClickShowResultsInBrowserOnly;
    private static TaskManager kInstance;
    private final List fToolRunnables = new ArrayList();
    private static final Icon RESULTS_ICON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final TaskManager getInstance() {
        if (kInstance != null) return kInstance;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (kInstance != null) return kInstance;
            kInstance = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return kInstance;
        }
    }

    private TaskManager() {
        this.fModel = new TaskManager$Model(this, null);
    }

    public final void setOnClickShowResultsInBrowserOnly(boolean bl) {
        this.fOnClickShowResultsInBrowserOnly = bl;
    }

    public final Tool run(Tool tool, ParamSet paramSet, int n) {
        Tool tool2;
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        if (paramSet == null) {
            throw new IllegalArgumentException("Param pset cannot be null");
        }
        try {
            tool2 = TaskManager.createTool(tool, paramSet);
        }
        catch (Exception exception) {
            TaskManager$ToolRunnable taskManager$ToolRunnable = TaskManager$ToolRunnable.access$100(tool, paramSet, exception);
            this.fToolRunnables.add(taskManager$ToolRunnable);
            kInstance.updateTable();
            throw exception;
        }
        TaskManager$ToolRunnable taskManager$ToolRunnable = new TaskManager$ToolRunnable(tool2, null);
        this.fToolRunnables.add(taskManager$ToolRunnable);
        kInstance.updateTable();
        Thread thread = new Thread(taskManager$ToolRunnable);
        thread.setPriority(n);
        TaskManager$ToolRunnable.access$302(taskManager$ToolRunnable, thread);
        thread.start();
        klog.debug("Started executing Tool: " + tool2.getName() + " priority: " + n);
        return tool2;
    }

    public static final Tool createTool(Tool tool, ParamSet paramSet) {
        String string = tool.getName();
        Class<?> clazz = Class.forName(string);
        klog.debug("toolClass: " + clazz + " pset: " + paramSet);
        Class[] classArray = new Class[]{Properties.class};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        klog.debug(constructor);
        Properties properties = paramSet.toProperties();
        properties.remove("help");
        Properties[] propertiesArray = new Properties[]{properties};
        System.out.println(">> " + properties);
        return (Tool)constructor.newInstance(propertiesArray);
    }

    public static final Tool createTool(String string) {
        Class<?> clazz = Class.forName(string);
        Class[] classArray = new Class[]{};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        return (Tool)constructor.newInstance(new Object[0]);
    }

    private void updateTable() {
        this.fModel.fireTableStructureChanged();
        this.fTaskTable.repaint();
        this.fTaskTable.revalidate();
        this.setColNumWidth(this.fTaskTable);
    }

    public final JTable createTable() {
        this.fTaskTable = new JTable(this.fModel);
        this.fTaskTable.setRowSelectionAllowed(false);
        this.fTaskTable.setColumnSelectionAllowed(false);
        this.fTaskTable.setSelectionMode(0);
        this.fTaskTable.setShowVerticalLines(true);
        this.fTaskTable.setGridColor(Color.black);
        this.fTaskTable.setAutoResizeMode(2);
        this.fTaskTable.getTableHeader().setReorderingAllowed(false);
        this.fTaskTable.setDefaultRenderer(Object.class, new TaskManager$Renderer(this, null));
        TaskManager$Editor taskManager$Editor = new TaskManager$Editor(this, null);
        this.fTaskTable.setDefaultEditor(Object.class, taskManager$Editor);
        this.setColNumWidth(this.fTaskTable);
        return this.fTaskTable;
    }

    private void setColNumWidth(JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
    }

    static final /* synthetic */ List access$400(TaskManager taskManager) {
        return taskManager.fToolRunnables;
    }

    static final /* synthetic */ String[] access$500() {
        return COL_HEADERS;
    }

    static final /* synthetic */ boolean access$800(TaskManager taskManager) {
        return taskManager.fOnClickShowResultsInBrowserOnly;
    }

    static final /* synthetic */ TaskManager access$1100() {
        return kInstance;
    }

    static final /* synthetic */ void access$1200(TaskManager taskManager) {
        taskManager.updateTable();
    }

    static final /* synthetic */ Logger access$1300() {
        return klog;
    }

    static final /* synthetic */ Icon access$1900() {
        return RESULTS_ICON;
    }

    static {
        RESULTS_ICON = JarResources.getIcon("Results.gif");
    }
}

