/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectIntHashMap;
import java.util.ConcurrentModificationException;

public class TObjectIntIterator
extends TIterator {
    private final TObjectIntHashMap _map;

    public TObjectIntIterator(TObjectIntHashMap tObjectIntHashMap) {
        super(tObjectIntHashMap);
        this._map = tObjectIntHashMap;
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] objectArray = this._map._set;
        int n = this._index;
        while (n-- > 0 && (objectArray[n] == TObjectHash.FREE || objectArray[n] == TObjectHash.REMOVED)) {
        }
        return n;
    }

    public final void advance() {
        this.moveToNextIndex();
    }

    public final Object key() {
        return this._map._set[this._index];
    }

    public final int value() {
        return this._map._values[this._index];
    }

    public final int setValue(int n) {
        int n2 = this.value();
        this._map._values[this._index] = n;
        return n2;
    }
}

