/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl$1;
import javax.media.jai.PropertyGenerator;

public abstract class OperationDescriptorImpl
implements OperationDescriptor {
    protected String[][] resources;
    protected Class[] sourceClasses;
    protected Class[] renderableSourceClasses;
    protected Class[] paramClasses;
    protected String[] paramNames;
    protected Object[] paramDefaults;
    private String name = null;
    static Class class$java$awt$image$RenderedImage;
    static Class class$java$awt$image$renderable$RenderableImage;
    static Class class$java$lang$Byte;
    static Class class$java$lang$Short;
    static Class class$java$lang$Integer;
    static Class class$java$lang$Long;
    static Class class$java$lang$Float;
    static Class class$java$lang$Double;

    public OperationDescriptorImpl(String[][] stringArray, int n) {
        this(stringArray, n, null, null, null);
    }

    public OperationDescriptorImpl(String[][] stringArray, int n, Class[] classArray, String[] stringArray2, Object[] objectArray) {
        this(stringArray, null, null, classArray, stringArray2, objectArray);
        if (n > 0) {
            int n2;
            if (this.isRenderedSupported()) {
                this.sourceClasses = new Class[n];
                n2 = 0;
                while (n2 < n) {
                    this.sourceClasses[n2] = class$java$awt$image$RenderedImage != null ? class$java$awt$image$RenderedImage : OperationDescriptorImpl.class$("java.awt.image.RenderedImage");
                    ++n2;
                }
            }
            if (this.isRenderableSupported()) {
                this.renderableSourceClasses = new Class[n];
                n2 = 0;
                while (n2 < n) {
                    this.renderableSourceClasses[n2] = class$java$awt$image$renderable$RenderableImage != null ? class$java$awt$image$renderable$RenderableImage : OperationDescriptorImpl.class$("java.awt.image.renderable.RenderableImage");
                    ++n2;
                }
            }
        }
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray) {
        this(stringArray, classArray, null, null, null, null);
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray, Class[] classArray2) {
        this(stringArray, classArray, classArray2, null, null, null);
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray, Class[] classArray2, Class[] classArray3, String[] stringArray2, Object[] objectArray) {
        if (stringArray == null) {
            throw new NullPointerException(JaiI18N.getString("OperationDescriptorImpl6"));
        }
        if (!this.isRenderedSupported() || classArray != null && classArray.length == 0) {
            classArray = null;
        }
        if (!this.isRenderableSupported() || classArray2 != null && classArray2.length == 0) {
            classArray2 = null;
        }
        if (this.isRenderedSupported() && this.isRenderableSupported() && (classArray != null || classArray2 != null) && classArray.length != classArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("OperationDescriptorImpl7"));
        }
        if (classArray3 != null && classArray3.length == 0) {
            classArray3 = null;
        }
        if (stringArray2 != null && stringArray2.length == 0) {
            stringArray2 = null;
        }
        if (objectArray != null && objectArray.length == 0) {
            objectArray = null;
        }
        if (classArray3 != null || stringArray2 != null) {
            if (objectArray == null) {
                int n = classArray3.length;
                objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = OperationDescriptor.NO_PARAMETER_DEFAULT;
                    ++n2;
                }
            }
            if (classArray3.length != stringArray2.length || classArray3.length != objectArray.length) {
                throw new IllegalArgumentException(JaiI18N.getString("OperationDescriptorImpl8"));
            }
        } else {
            objectArray = null;
        }
        this.resources = stringArray;
        this.sourceClasses = classArray;
        this.renderableSourceClasses = classArray2;
        this.paramClasses = classArray3;
        this.paramNames = stringArray2;
        this.paramDefaults = objectArray;
    }

    public OperationDescriptorImpl(String[][] stringArray, Class[] classArray, String[] stringArray2, Object[] objectArray) {
        this(stringArray, null, null, classArray, stringArray2, objectArray);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private MessageFormat createFormatter(String string) {
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.setLocale(Locale.getDefault());
        return messageFormat;
    }

    public Class getDestClass() {
        return this.isRenderedSupported() ? (class$java$awt$image$RenderedImage != null ? class$java$awt$image$RenderedImage : (class$java$awt$image$RenderedImage = OperationDescriptorImpl.class$("java.awt.image.RenderedImage"))) : null;
    }

    private int getMinNumParameters() {
        int n = this.getNumParameters();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.paramDefaults[n2] == OperationDescriptor.NO_PARAMETER_DEFAULT) break;
            --n;
            --n2;
        }
        return n;
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)this.getResourceBundle(Locale.getDefault()).getObject("GlobalName");
        }
        return this.name;
    }

    public int getNumParameters() {
        return this.paramClasses == null ? 0 : this.paramClasses.length;
    }

    public int getNumSources() {
        if (this.isRenderedSupported()) {
            return this.sourceClasses == null ? 0 : this.sourceClasses.length;
        }
        if (this.isRenderableSupported()) {
            return this.renderableSourceClasses == null ? 0 : this.renderableSourceClasses.length;
        }
        return 0;
    }

    public Class[] getParamClasses() {
        return this.paramClasses;
    }

    public Object getParamDefaultValue(int n) {
        return this.paramDefaults[n];
    }

    public Object[] getParamDefaults() {
        return this.paramDefaults;
    }

    public Number getParamMaxValue(int n) {
        Class clazz = this.paramClasses[n];
        if (clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = OperationDescriptorImpl.class$("java.lang.Byte")))) {
            return new Byte(127);
        }
        if (clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = OperationDescriptorImpl.class$("java.lang.Short")))) {
            return new Short(Short.MAX_VALUE);
        }
        if (clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = OperationDescriptorImpl.class$("java.lang.Integer")))) {
            return new Integer(Integer.MAX_VALUE);
        }
        if (clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = OperationDescriptorImpl.class$("java.lang.Long")))) {
            return new Long(Long.MAX_VALUE);
        }
        if (clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = OperationDescriptorImpl.class$("java.lang.Float")))) {
            return new Float(Float.MAX_VALUE);
        }
        if (clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = OperationDescriptorImpl.class$("java.lang.Double")))) {
            return new Double(Double.MAX_VALUE);
        }
        return null;
    }

    public Number getParamMinValue(int n) {
        Class clazz = this.paramClasses[n];
        if (clazz == (class$java$lang$Byte != null ? class$java$lang$Byte : (class$java$lang$Byte = OperationDescriptorImpl.class$("java.lang.Byte")))) {
            return new Byte(-128);
        }
        if (clazz == (class$java$lang$Short != null ? class$java$lang$Short : (class$java$lang$Short = OperationDescriptorImpl.class$("java.lang.Short")))) {
            return new Short(Short.MIN_VALUE);
        }
        if (clazz == (class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = OperationDescriptorImpl.class$("java.lang.Integer")))) {
            return new Integer(Integer.MIN_VALUE);
        }
        if (clazz == (class$java$lang$Long != null ? class$java$lang$Long : (class$java$lang$Long = OperationDescriptorImpl.class$("java.lang.Long")))) {
            return new Long(Long.MIN_VALUE);
        }
        if (clazz == (class$java$lang$Float != null ? class$java$lang$Float : (class$java$lang$Float = OperationDescriptorImpl.class$("java.lang.Float")))) {
            return new Float(-3.4028235E38f);
        }
        if (clazz == (class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = OperationDescriptorImpl.class$("java.lang.Double")))) {
            return new Double(-1.7976931348623157E308);
        }
        return null;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        return null;
    }

    public Class getRenderableDestClass() {
        return this.isRenderableSupported() ? (class$java$awt$image$renderable$RenderableImage != null ? class$java$awt$image$renderable$RenderableImage : (class$java$awt$image$renderable$RenderableImage = OperationDescriptorImpl.class$("java.awt.image.renderable.RenderableImage"))) : null;
    }

    public Class[] getRenderableSourceClasses() {
        return this.renderableSourceClasses;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        Locale locale2 = locale;
        return new OperationDescriptorImpl$1(locale2, this);
    }

    public String[][] getResources(Locale locale) {
        return this.resources;
    }

    public Class[] getSourceClasses() {
        return this.sourceClasses;
    }

    public boolean isImmediate() {
        return false;
    }

    public boolean isRenderableSupported() {
        return false;
    }

    public boolean isRenderedSupported() {
        return true;
    }

    public boolean validateArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        return this.validateSources(parameterBlock, stringBuffer) && this.validateParameters(parameterBlock, stringBuffer);
    }

    protected boolean validateParameters(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        int n;
        int n2 = this.getNumParameters();
        int n3 = parameterBlock.getNumParameters();
        if (n3 < n2) {
            if (n3 < this.getMinNumParameters()) {
                MessageFormat messageFormat = this.createFormatter(JaiI18N.getString("OperationDescriptorImpl3"));
                Object[] objectArray = new Object[]{new Integer(n2)};
                stringBuffer.append(String.valueOf(this.getName()) + " " + messageFormat.format(objectArray));
                return false;
            }
            n = n3;
            while (n < n2) {
                parameterBlock.add(this.paramDefaults[n]);
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Serializable serializable;
            Object object = parameterBlock.getObjectParameter(n);
            if (object == null) {
                object = this.paramDefaults[n];
                if (object == OperationDescriptor.NO_PARAMETER_DEFAULT) {
                    serializable = this.createFormatter(JaiI18N.getString("OperationDescriptorImpl4"));
                    objectArray2 = new Object[]{new Integer(n)};
                    stringBuffer.append(String.valueOf(this.getName()) + " " + ((Format)serializable).format(objectArray2));
                    return false;
                }
                parameterBlock.set(object, n);
            }
            serializable = this.paramClasses[n];
            if (object != null && !((Class)serializable).isInstance(object)) {
                objectArray2 = this.createFormatter(JaiI18N.getString("OperationDescriptorImpl5"));
                objectArray = new Object[]{new Integer(n), new String(((Class)serializable).toString()), new String(object.getClass().toString())};
                stringBuffer.append(String.valueOf(this.getName()) + " " + objectArray2.format(objectArray));
                return false;
            }
            if (object != null && object instanceof Number) {
                objectArray2 = (Number)object;
                objectArray = this.getParamMinValue(n);
                Number number = this.getParamMaxValue(n);
                boolean bl = true;
                if (objectArray2 instanceof Byte) {
                    byte by = objectArray2.byteValue();
                    if (objectArray != null && by < objectArray.byteValue() || number != null && by > number.byteValue()) {
                        bl = false;
                    }
                } else if (objectArray2 instanceof Short) {
                    short s = objectArray2.shortValue();
                    if (objectArray != null && s < objectArray.shortValue() || number != null && s > number.shortValue()) {
                        bl = false;
                    }
                } else if (objectArray2 instanceof Integer) {
                    int n4 = objectArray2.intValue();
                    if (objectArray != null && n4 < objectArray.intValue() || number != null && n4 > number.intValue()) {
                        bl = false;
                    }
                } else if (objectArray2 instanceof Long) {
                    long l2 = objectArray2.longValue();
                    if (objectArray != null && l2 < objectArray.longValue() || number != null && l2 > number.longValue()) {
                        bl = false;
                    }
                } else if (objectArray2 instanceof Float) {
                    float f2 = objectArray2.floatValue();
                    if (objectArray != null && f2 < objectArray.floatValue() || number != null && f2 > number.floatValue()) {
                        bl = false;
                    }
                } else if (objectArray2 instanceof Double) {
                    double d2 = objectArray2.doubleValue();
                    if (objectArray != null && d2 < objectArray.doubleValue() || number != null && d2 > number.doubleValue()) {
                        bl = false;
                    }
                }
                if (!bl) {
                    stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("OperationDescriptorImpl9"));
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public boolean validateRenderableArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        return this.validateRenderableSources(parameterBlock, stringBuffer) && this.validateParameters(parameterBlock, stringBuffer);
    }

    protected final boolean validateRenderableSources(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        return this.isRenderableSupported() && this.validateSources(this.renderableSourceClasses, parameterBlock, stringBuffer);
    }

    protected boolean validateSources(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        return this.isRenderedSupported() && this.validateSources(this.sourceClasses, parameterBlock, stringBuffer);
    }

    private boolean validateSources(Class[] classArray, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        int n = this.getNumSources();
        if (parameterBlock.getNumSources() < n) {
            MessageFormat messageFormat = this.createFormatter(JaiI18N.getString("OperationDescriptorImpl0"));
            Object[] objectArray = new Object[]{new Integer(n)};
            stringBuffer.append(String.valueOf(this.getName()) + " " + messageFormat.format(objectArray));
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            Object object = parameterBlock.getSource(n2);
            if (object == null) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("OperationDescriptorImpl1"));
                return false;
            }
            Class clazz = classArray[n2];
            if (!clazz.isInstance(object)) {
                MessageFormat messageFormat = this.createFormatter(JaiI18N.getString("OperationDescriptorImpl2"));
                Object[] objectArray = new Object[]{new Integer(n2), new String(clazz.toString()), new String(object.getClass().toString())};
                stringBuffer.append(String.valueOf(this.getName()) + " " + messageFormat.format(objectArray));
                return false;
            }
            ++n2;
        }
        return true;
    }
}

