/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;

public final class RenderableImageAdapter
implements RenderableImage,
PropertySource {
    private RenderableImage im;

    public RenderableImageAdapter(RenderableImage renderableImage) {
        this.im = renderableImage;
    }

    public final RenderedImage createDefaultRendering() {
        return this.im.createDefaultRendering();
    }

    public final RenderedImage createRendering(RenderContext renderContext) {
        return this.im.createRendering(renderContext);
    }

    public final RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        return this.im.createScaledRendering(n, n2, renderingHints);
    }

    public final float getHeight() {
        return this.im.getHeight();
    }

    public final float getMinX() {
        return this.im.getMinX();
    }

    public final float getMinY() {
        return this.im.getMinY();
    }

    public final Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderableImageAdapter0"));
        }
        return this.im.getProperty(string);
    }

    public final String[] getPropertyNames() {
        return this.im.getPropertyNames();
    }

    public final String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        return PlanarImage.getPropertyNames(stringArray, string);
    }

    public final Vector getSources() {
        return this.im.getSources();
    }

    public final float getWidth() {
        return this.im.getWidth();
    }

    public final boolean isDynamic() {
        return this.im.isDynamic();
    }

    public static final RenderableImageAdapter wrapRenderableImage(RenderableImage renderableImage) {
        if (renderableImage == null) {
            throw new NullPointerException();
        }
        if (renderableImage instanceof RenderableImageAdapter) {
            return (RenderableImageAdapter)renderableImage;
        }
        return new RenderableImageAdapter(renderableImage);
    }
}

