/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.Warp;

public abstract class WarpOpImage
extends OpImage {
    protected Warp warp;
    protected Interpolation interp;
    protected Rectangle writableBounds;

    public WarpOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, Warp warp, Interpolation interpolation, boolean bl) {
        super(renderedImage, borderExtender, tileCache, imageLayout, bl);
        this.warp = warp;
        this.interp = interpolation;
        if (bl && borderExtender == null) {
            int n = this.getLeftPadding();
            int n2 = this.getRightPadding();
            int n3 = this.getTopPadding();
            int n4 = this.getBottomPadding();
            int n5 = this.getMinX() + n;
            int n6 = this.getMinY() + n3;
            int n7 = Math.max(this.getWidth() - n - n2, 0);
            int n8 = Math.max(this.getHeight() - n3 - n4, 0);
            this.writableBounds = new Rectangle(n5, n6, n7, n8);
        } else {
            this.writableBounds = this.getBounds();
        }
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight).intersection(this.writableBounds);
        if (rectangle.isEmpty()) {
            return writableRaster;
        }
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        if (!rectangle2.intersects(this.source0.getBounds())) {
            return writableRaster;
        }
        if (this.cobbleSources) {
            Raster[] rasterArray = new Raster[]{this.hasExtender(0) ? this.source0.getExtendedData(rectangle2, this.extenders[0]) : this.source0.getData(rectangle2)};
            this.computeRect(rasterArray, writableRaster, rectangle);
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[]{this.source0};
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }

    public final int getBottomPadding() {
        return this.interp == null ? 0 : this.interp.getBottomPadding();
    }

    public final int getLeftPadding() {
        return this.interp == null ? 0 : this.interp.getLeftPadding();
    }

    public final int getRightPadding() {
        return this.interp == null ? 0 : this.interp.getRightPadding();
    }

    public final int getTopPadding() {
        return this.interp == null ? 0 : this.interp.getTopPadding();
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        Rectangle rectangle2;
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        Rectangle rectangle3 = rectangle2 = this.warp == null ? null : this.warp.mapDestRect(rectangle);
        if (rectangle2 == null) {
            return this.source0.getBounds();
        }
        int n2 = this.getLeftPadding();
        int n3 = this.getRightPadding();
        int n4 = this.getTopPadding();
        int n5 = this.getBottomPadding();
        return new Rectangle(rectangle2.x - n2, rectangle2.y - n4, rectangle2.width + n2 + n3, rectangle2.height + n4 + n5);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        if (rectangle == null) {
            throw new NullPointerException();
        }
        return this.getBounds();
    }
}

