/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import common.Logger;
import java.util.HashMap;
import java.util.Locale;
import jxl.biff.CountryCode;
import jxl.biff.formula.FunctionNames;

public final class WorkbookSettings {
    private static Logger logger = Logger.getLogger(class$jxl$WorkbookSettings == null ? (class$jxl$WorkbookSettings = WorkbookSettings.class$("jxl.WorkbookSettings")) : class$jxl$WorkbookSettings);
    private int initialFileSize = 0x500000;
    private int arrayGrowSize = 0x100000;
    private boolean drawingsDisabled;
    private boolean namesDisabled;
    private boolean formulaReferenceAdjustDisabled;
    private boolean gcDisabled;
    private boolean rationalizationDisabled;
    private boolean mergedCellCheckingDisabled;
    private boolean propertySetsDisabled;
    private boolean ignoreBlankCells;
    private Locale locale;
    private FunctionNames functionNames;
    private String encoding;
    private int characterSet;
    private String excelDisplayLanguage;
    private String excelRegionalSettings;
    private HashMap localeFunctionNames = new HashMap();
    private static final int defaultInitialFileSize = 0x500000;
    private static final int defaultArrayGrowSize = 0x100000;
    static Class class$jxl$WorkbookSettings;

    public WorkbookSettings() {
        this.excelDisplayLanguage = CountryCode.USA.getCode();
        this.excelRegionalSettings = CountryCode.UK.getCode();
        try {
            boolean bl = Boolean.getBoolean("jxl.nowarnings");
            this.setSuppressWarnings(bl);
            this.drawingsDisabled = Boolean.getBoolean("jxl.nodrawings");
            this.namesDisabled = Boolean.getBoolean("jxl.nonames");
            this.gcDisabled = Boolean.getBoolean("jxl.nogc");
            this.rationalizationDisabled = Boolean.getBoolean("jxl.norat");
            this.mergedCellCheckingDisabled = Boolean.getBoolean("jxl.nomergedcellchecks");
            this.formulaReferenceAdjustDisabled = Boolean.getBoolean("jxl.noformulaadjust");
            this.propertySetsDisabled = Boolean.getBoolean("jxl.nopropertysets");
            this.ignoreBlankCells = Boolean.getBoolean("jxl.ignoreblanks");
            this.encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            logger.warn("Error accessing system properties.", securityException);
        }
        try {
            this.locale = System.getProperty("jxl.lang") == null || System.getProperty("jxl.country") == null ? Locale.getDefault() : new Locale(System.getProperty("jxl.lang"), System.getProperty("jxl.country"));
            if (System.getProperty("jxl.encoding") != null) {
                this.encoding = System.getProperty("jxl.encoding");
            }
        }
        catch (SecurityException securityException) {
            logger.warn("Error accessing system properties.", securityException);
            this.locale = Locale.getDefault();
        }
    }

    public final void setArrayGrowSize(int n) {
        this.arrayGrowSize = n;
    }

    public final int getArrayGrowSize() {
        return this.arrayGrowSize;
    }

    public final void setInitialFileSize(int n) {
        this.initialFileSize = n;
    }

    public final int getInitialFileSize() {
        return this.initialFileSize;
    }

    public final boolean getDrawingsDisabled() {
        return this.drawingsDisabled;
    }

    public final boolean getGCDisabled() {
        return this.gcDisabled;
    }

    public final boolean getNamesDisabled() {
        return this.namesDisabled;
    }

    public final void setNamesDisabled(boolean bl) {
        this.namesDisabled = bl;
    }

    public final void setDrawingsDisabled(boolean bl) {
        this.drawingsDisabled = bl;
    }

    public final void setRationalization(boolean bl) {
        this.rationalizationDisabled = !bl;
    }

    public final boolean getRationalizationDisabled() {
        return this.rationalizationDisabled;
    }

    public final boolean getMergedCellCheckingDisabled() {
        return this.mergedCellCheckingDisabled;
    }

    public final void setMergedCellChecking(boolean bl) {
        this.mergedCellCheckingDisabled = !bl;
    }

    public final void setPropertySets(boolean bl) {
        this.propertySetsDisabled = !bl;
    }

    public final boolean getPropertySetsDisabled() {
        return this.propertySetsDisabled;
    }

    public final void setSuppressWarnings(boolean bl) {
        logger.setSuppressWarnings(bl);
    }

    public final boolean getFormulaAdjust() {
        return !this.formulaReferenceAdjustDisabled;
    }

    public final void setFormulaAdjust(boolean bl) {
        this.formulaReferenceAdjustDisabled = !bl;
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public final FunctionNames getFunctionNames() {
        if (this.functionNames == null) {
            this.functionNames = (FunctionNames)this.localeFunctionNames.get(this.locale);
            if (this.functionNames == null) {
                this.functionNames = new FunctionNames(this.locale);
                this.localeFunctionNames.put(this.locale, this.functionNames);
            }
        }
        return this.functionNames;
    }

    public final int getCharacterSet() {
        return this.characterSet;
    }

    public final void setCharacterSet(int n) {
        this.characterSet = n;
    }

    public final void setGCDisabled(boolean bl) {
        this.gcDisabled = bl;
    }

    public final void setIgnoreBlanks(boolean bl) {
        this.ignoreBlankCells = bl;
    }

    public final boolean getIgnoreBlanks() {
        return this.ignoreBlankCells;
    }

    public final String getExcelDisplayLanguage() {
        return this.excelDisplayLanguage;
    }

    public final String getExcelRegionalSettings() {
        return this.excelRegionalSettings;
    }

    public final void setExcelDisplayLanguage(String string) {
        this.excelDisplayLanguage = string;
    }

    public final void setExcelRegionalSettings(String string) {
        this.excelRegionalSettings = string;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

