/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class Area3d
extends Operand
implements ParsedThing {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$Area3d == null ? (class$jxl$biff$formula$Area3d = Area3d.class$("jxl.biff.formula.Area3d")) : class$jxl$biff$formula$Area3d);
    private int sheet;
    private int columnFirst;
    private int rowFirst;
    private int columnLast;
    private int rowLast;
    private boolean columnFirstRelative;
    private boolean rowFirstRelative;
    private boolean columnLastRelative;
    private boolean rowLastRelative;
    private ExternalSheet workbook;
    static Class class$jxl$biff$formula$Area3d;

    Area3d(ExternalSheet externalSheet) {
        this.workbook = externalSheet;
    }

    Area3d(String string, ExternalSheet externalSheet) {
        this.workbook = externalSheet;
        int n = string.lastIndexOf(":");
        Assert.verify(n != -1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = string.indexOf(33);
        String string4 = string.substring(n2 + 1, n);
        this.columnFirst = CellReferenceHelper.getColumn(string4);
        this.rowFirst = CellReferenceHelper.getRow(string4);
        String string5 = string.substring(0, n2);
        int n3 = string5.lastIndexOf(93);
        if (string5.charAt(0) == '\'' && string5.charAt(string5.length() - 1) == '\'') {
            string5 = string5.substring(1, string5.length() - 1);
        }
        this.sheet = externalSheet.getExternalSheetIndex(string5);
        if (this.sheet < 0) {
            throw new FormulaException(FormulaException.sheetRefNotFound, string5);
        }
        this.columnLast = CellReferenceHelper.getColumn(string3);
        this.rowLast = CellReferenceHelper.getRow(string3);
        this.columnFirstRelative = true;
        this.rowFirstRelative = true;
        this.columnLastRelative = true;
        this.rowLastRelative = true;
    }

    final int getFirstColumn() {
        return this.columnFirst;
    }

    private final int getFirstRow() {
        return this.rowFirst;
    }

    final int getLastColumn() {
        return this.columnLast;
    }

    private final int getLastRow() {
        return this.rowLast;
    }

    public int read(byte[] byArray, int n) {
        this.sheet = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.rowFirst = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        this.rowLast = IntegerHelper.getInt(byArray[n + 4], byArray[n + 5]);
        int n2 = IntegerHelper.getInt(byArray[n + 6], byArray[n + 7]);
        this.columnFirst = n2 & 0xFF;
        this.columnFirstRelative = (n2 & 0x4000) != 0;
        this.rowFirstRelative = (n2 & 0x8000) != 0;
        n2 = IntegerHelper.getInt(byArray[n + 8], byArray[n + 9]);
        this.columnLast = n2 & 0xFF;
        this.columnLastRelative = (n2 & 0x4000) != 0;
        this.rowLastRelative = (n2 & 0x8000) != 0;
        return 10;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.sheet, this.columnFirst, this.rowFirst, this.workbook, stringBuffer);
        stringBuffer.append(':');
        CellReferenceHelper.getCellReference(this.columnLast, this.rowLast, stringBuffer);
    }

    final byte[] getBytes() {
        byte[] byArray = new byte[11];
        byArray[0] = Token.AREA3D.getCode();
        IntegerHelper.getTwoBytes(this.sheet, byArray, 1);
        IntegerHelper.getTwoBytes(this.rowFirst, byArray, 3);
        IntegerHelper.getTwoBytes(this.rowLast, byArray, 5);
        int n = this.columnFirst;
        if (this.rowFirstRelative) {
            n |= 0x8000;
        }
        if (this.columnFirstRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 7);
        n = this.columnLast;
        if (this.rowLastRelative) {
            n |= 0x8000;
        }
        if (this.columnLastRelative) {
            n |= 0x4000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 9);
        return byArray;
    }

    public final void adjustRelativeCellReferences(int n, int n2) {
        if (this.columnFirstRelative) {
            this.columnFirst += n;
        }
        if (this.columnLastRelative) {
            this.columnLast += n;
        }
        if (this.rowFirstRelative) {
            this.rowFirst += n2;
        }
        if (this.rowLastRelative) {
            this.rowLast += n2;
        }
    }

    public final void columnInserted(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.columnFirst >= n2) {
            ++this.columnFirst;
        }
        if (this.columnLast >= n2) {
            ++this.columnLast;
        }
    }

    final void columnRemoved(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (n2 < this.columnFirst) {
            --this.columnFirst;
        }
        if (n2 <= this.columnLast) {
            --this.columnLast;
        }
    }

    final void rowInserted(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.rowLast == 65535) {
            return;
        }
        if (n2 <= this.rowFirst) {
            ++this.rowFirst;
        }
        if (n2 <= this.rowLast) {
            ++this.rowLast;
        }
    }

    final void rowRemoved(int n, int n2, boolean bl) {
        if (n != this.sheet) {
            return;
        }
        if (this.rowLast == 65535) {
            return;
        }
        if (n2 < this.rowFirst) {
            --this.rowFirst;
        }
        if (n2 <= this.rowLast) {
            --this.rowLast;
        }
    }

    protected final void setRangeData(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.sheet = n;
        this.columnFirst = n2;
        this.columnLast = n3;
        this.rowFirst = n4;
        this.rowLast = n5;
        this.columnFirstRelative = bl;
        this.columnLastRelative = bl2;
        this.rowFirstRelative = bl3;
        this.rowLastRelative = bl4;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

