/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class BuiltInFunction
extends Operator
implements ParsedThing {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$BuiltInFunction == null ? (class$jxl$biff$formula$BuiltInFunction = BuiltInFunction.class$("jxl.biff.formula.BuiltInFunction")) : class$jxl$biff$formula$BuiltInFunction);
    private Function function;
    private WorkbookSettings settings;
    static Class class$jxl$biff$formula$BuiltInFunction;

    public BuiltInFunction(WorkbookSettings workbookSettings) {
        this.settings = workbookSettings;
    }

    public BuiltInFunction(Function function, WorkbookSettings workbookSettings) {
        this.function = function;
        this.settings = workbookSettings;
    }

    public final int read(byte[] byArray, int n) {
        int n2 = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.function = Function.getFunction(n2);
        Assert.verify(this.function != Function.UNKNOWN, "function code " + n2);
        return 2;
    }

    public final void getOperands(Stack stack) {
        int n;
        ParseItem[] parseItemArray = new ParseItem[this.function.getNumArgs()];
        for (n = this.function.getNumArgs() - 1; n >= 0; --n) {
            ParseItem parseItem;
            parseItemArray[n] = parseItem = (ParseItem)stack.pop();
        }
        for (n = 0; n < this.function.getNumArgs(); ++n) {
            this.add(parseItemArray[n]);
        }
    }

    public final void getString(StringBuffer stringBuffer) {
        stringBuffer.append(this.function.getName(this.settings));
        stringBuffer.append('(');
        int n = this.function.getNumArgs();
        if (n > 0) {
            ParseItem[] parseItemArray = this.getOperands();
            parseItemArray[0].getString(stringBuffer);
            for (int i2 = 1; i2 < n; ++i2) {
                stringBuffer.append(',');
                parseItemArray[i2].getString(stringBuffer);
            }
        }
        stringBuffer.append(')');
    }

    public final void adjustRelativeCellReferences(int n, int n2) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i2 = 0; i2 < parseItemArray.length; ++i2) {
            parseItemArray[i2].adjustRelativeCellReferences(n, n2);
        }
    }

    final void columnInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i2 = 0; i2 < parseItemArray.length; ++i2) {
            parseItemArray[i2].columnInserted(n, n2, bl);
        }
    }

    final void columnRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i2 = 0; i2 < parseItemArray.length; ++i2) {
            parseItemArray[i2].columnRemoved(n, n2, bl);
        }
    }

    final void rowInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i2 = 0; i2 < parseItemArray.length; ++i2) {
            parseItemArray[i2].rowInserted(n, n2, bl);
        }
    }

    final void rowRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i2 = 0; i2 < parseItemArray.length; ++i2) {
            parseItemArray[i2].rowRemoved(n, n2, bl);
        }
    }

    final byte[] getBytes() {
        ParseItem[] parseItemArray = this.getOperands();
        byte[] byArray = new byte[]{};
        for (int i2 = 0; i2 < parseItemArray.length; ++i2) {
            byte[] byArray2 = parseItemArray[i2].getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = byArray3;
        }
        byte[] byArray4 = new byte[byArray.length + 3];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        byArray4[byArray.length] = !this.useAlternateCode() ? Token.FUNCTION.getCode() : Token.FUNCTION.getCode2();
        IntegerHelper.getTwoBytes(this.function.getCode(), byArray4, byArray.length + 1);
        return byArray4;
    }

    final int getPrecedence() {
        return 3;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

