/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

public class BOFRecord
extends RecordData {
    private static final int Biff8 = 1536;
    private static final int Biff7 = 1280;
    private static final int WorkbookGlobals = 5;
    private static final int Worksheet = 16;
    private static final int Chart = 32;
    private static final int MacroSheet = 64;
    private int version;
    private int substreamType;

    BOFRecord(Record record) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.version = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.substreamType = IntegerHelper.getInt(byArray[2], byArray[3]);
    }

    public final boolean isBiff8() {
        return this.version == 1536;
    }

    public final boolean isBiff7() {
        return this.version == 1280;
    }

    final boolean isWorkbookGlobals() {
        return this.substreamType == 5;
    }

    public final boolean isWorksheet() {
        return this.substreamType == 16;
    }

    public final boolean isMacroSheet() {
        return this.substreamType == 64;
    }

    public final boolean isChart() {
        return this.substreamType == 32;
    }

    final int getLength() {
        return this.getRecord().getLength();
    }
}

