/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import jxl.CellType;
import jxl.WorkbookSettings;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BooleanFormulaRecord;
import jxl.read.biff.CellValue;
import jxl.read.biff.ErrorFormulaRecord;
import jxl.read.biff.File;
import jxl.read.biff.FormulaRecord$IgnoreSharedFormula;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SharedErrorFormulaRecord;
import jxl.read.biff.SharedNumberFormulaRecord;
import jxl.read.biff.SharedStringFormulaRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.StringFormulaRecord;

class FormulaRecord
extends CellValue {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$FormulaRecord == null ? (class$jxl$read$biff$FormulaRecord = FormulaRecord.class$("jxl.read.biff.FormulaRecord")) : class$jxl$read$biff$FormulaRecord);
    private CellValue formula;
    private boolean shared;
    public static final FormulaRecord$IgnoreSharedFormula ignoreSharedFormula = new FormulaRecord$IgnoreSharedFormula(null);
    static Class class$jxl$read$biff$FormulaRecord;

    public FormulaRecord(Record record, File file, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, SheetImpl sheetImpl, WorkbookSettings workbookSettings) {
        super(record, formattingRecords, sheetImpl);
        byte[] byArray = this.getRecord().getData();
        this.shared = false;
        int n = IntegerHelper.getInt(byArray[14], byArray[15]);
        if ((n & 8) != 0) {
            this.shared = true;
            if (byArray[6] == 0 && byArray[12] == -1 && byArray[13] == -1) {
                this.formula = new SharedStringFormulaRecord(record, file, formattingRecords, externalSheet, workbookMethods, sheetImpl, workbookSettings);
            } else if (byArray[6] == 2 && byArray[12] == -1 && byArray[13] == -1) {
                byte by = byArray[8];
                this.formula = new SharedErrorFormulaRecord(record, file, by, formattingRecords, externalSheet, workbookMethods, sheetImpl);
            } else {
                double d2 = DoubleHelper.getIEEEDouble(byArray, 6);
                SharedNumberFormulaRecord sharedNumberFormulaRecord = new SharedNumberFormulaRecord(record, file, d2, formattingRecords, externalSheet, workbookMethods, sheetImpl);
                sharedNumberFormulaRecord.setNumberFormat(formattingRecords.getNumberFormat(this.getXFIndex()));
                this.formula = sharedNumberFormulaRecord;
            }
            return;
        }
        this.formula = byArray[6] == 0 && byArray[12] == -1 && byArray[13] == -1 ? new StringFormulaRecord(record, file, formattingRecords, externalSheet, workbookMethods, sheetImpl, workbookSettings) : (byArray[6] == 1 && byArray[12] == -1 && byArray[13] == -1 ? new BooleanFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl) : (byArray[6] == 2 && byArray[12] == -1 && byArray[13] == -1 ? new ErrorFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl) : (byArray[6] == 3 && byArray[12] == -1 && byArray[13] == -1 ? new StringFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl) : new NumberFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl))));
    }

    public FormulaRecord(Record record, File file, FormattingRecords formattingRecords, ExternalSheet externalSheet, WorkbookMethods workbookMethods, FormulaRecord$IgnoreSharedFormula formulaRecord$IgnoreSharedFormula, SheetImpl sheetImpl, WorkbookSettings workbookSettings) {
        super(record, formattingRecords, sheetImpl);
        byte[] byArray = this.getRecord().getData();
        this.shared = false;
        this.formula = byArray[6] == 0 && byArray[12] == -1 && byArray[13] == -1 ? new StringFormulaRecord(record, file, formattingRecords, externalSheet, workbookMethods, sheetImpl, workbookSettings) : (byArray[6] == 1 && byArray[12] == -1 && byArray[13] == -1 ? new BooleanFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl) : (byArray[6] == 2 && byArray[12] == -1 && byArray[13] == -1 ? new ErrorFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl) : new NumberFormulaRecord(record, formattingRecords, externalSheet, workbookMethods, sheetImpl)));
    }

    public final String getContents() {
        Assert.verify(false);
        return "";
    }

    public final CellType getType() {
        Assert.verify(false);
        return CellType.EMPTY;
    }

    final CellValue getFormula() {
        return this.formula;
    }

    final boolean isShared() {
        return this.shared;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

