/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.BooleanCell;
import jxl.CellType;
import jxl.biff.Type;
import jxl.format.CellFormat;
import jxl.write.biff.CellValue;

public abstract class BooleanRecord
extends CellValue {
    private boolean value;

    protected BooleanRecord(int n, int n2, boolean bl) {
        super(Type.BOOLERR, n, n2);
        this.value = bl;
    }

    protected BooleanRecord(int n, int n2, boolean bl, CellFormat cellFormat) {
        super(Type.BOOLERR, n, n2, cellFormat);
        this.value = bl;
    }

    protected BooleanRecord(BooleanCell booleanCell) {
        super(Type.BOOLERR, booleanCell);
        this.value = booleanCell.getValue();
    }

    protected BooleanRecord(int n, int n2, BooleanRecord booleanRecord) {
        super(Type.BOOLERR, n, n2, booleanRecord);
        this.value = booleanRecord.value;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public CellType getType() {
        return CellType.BOOLEAN;
    }

    protected void setValue(boolean bl) {
        this.value = bl;
    }

    public final byte[] getData() {
        byte[] byArray = super.getData();
        byte[] byArray2 = new byte[byArray.length + 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (this.value) {
            byArray2[byArray.length] = 1;
        }
        return byArray2;
    }
}

