/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;

class ColumnInfoRecord
extends WritableRecordData {
    private byte[] data;
    private int column;
    private XFRecord style;
    private int xfIndex;
    private int width;
    private boolean hidden;

    public ColumnInfoRecord(int n, int n2, XFRecord xFRecord) {
        super(Type.COLINFO);
        this.column = n;
        this.width = n2;
        this.style = xFRecord;
        this.xfIndex = this.style.getXFIndex();
        this.hidden = false;
    }

    public ColumnInfoRecord(jxl.read.biff.ColumnInfoRecord columnInfoRecord, int n, FormattingRecords formattingRecords) {
        super(Type.COLINFO);
        this.column = n;
        this.width = columnInfoRecord.getWidth();
        this.xfIndex = columnInfoRecord.getXFIndex();
        this.style = formattingRecords.getXFRecord(this.xfIndex);
    }

    public final int getColumn() {
        return this.column;
    }

    public final void incrementColumn() {
        ++this.column;
    }

    public final void decrementColumn() {
        --this.column;
    }

    final int getWidth() {
        return this.width;
    }

    public final byte[] getData() {
        this.data = new byte[12];
        IntegerHelper.getTwoBytes(this.column, this.data, 0);
        IntegerHelper.getTwoBytes(this.column, this.data, 2);
        IntegerHelper.getTwoBytes(this.width, this.data, 4);
        IntegerHelper.getTwoBytes(this.xfIndex, this.data, 6);
        int n = 6;
        if (this.hidden) {
            n |= 1;
        }
        IntegerHelper.getTwoBytes(n, this.data, 8);
        return this.data;
    }

    public final XFRecord getCellFormat() {
        return this.style;
    }

    final void rationalize(IndexMapping indexMapping) {
        this.xfIndex = indexMapping.getNewIndex(this.xfIndex);
    }

    final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    final boolean getHidden() {
        return this.hidden;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColumnInfoRecord)) {
            return false;
        }
        ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)object;
        int n = columnInfoRecord.column;
        if (this.column != columnInfoRecord.column || this.xfIndex != columnInfoRecord.xfIndex || this.width != columnInfoRecord.width || this.hidden != columnInfoRecord.hidden) {
            return false;
        }
        if (this.style == null && columnInfoRecord.style != null || this.style != null && columnInfoRecord.style == null) {
            return false;
        }
        return this.style.equals(columnInfoRecord.style);
    }

    public final int hashCode() {
        int n = 137;
        int n2 = 79;
        n = n * n2 + this.column;
        n = n * n2 + this.xfIndex;
        n = n * n2 + this.width;
        n = n * n2 + (this.hidden ? 1 : 0);
        if (this.style != null) {
            n ^= this.style.hashCode();
        }
        return n;
    }
}

