/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.List;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Number;
import jxl.write.biff.CellValue;

class MulRKRecord
extends WritableRecordData {
    private int row;
    private int colFirst;
    private int colLast;
    private int[] rknumbers;
    private int[] xfIndices;

    public MulRKRecord(List list) {
        super(Type.MULRK);
        this.row = ((Number)list.get(0)).getRow();
        this.colFirst = ((Number)list.get(0)).getColumn();
        this.colLast = this.colFirst + list.size() - 1;
        this.rknumbers = new int[list.size()];
        this.xfIndices = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.rknumbers[i2] = (int)((Number)list.get(i2)).getValue();
            this.xfIndices[i2] = ((CellValue)list.get(i2)).getXFIndex();
        }
    }

    public final byte[] getData() {
        byte[] byArray = new byte[this.rknumbers.length * 6 + 6];
        IntegerHelper.getTwoBytes(this.row, byArray, 0);
        IntegerHelper.getTwoBytes(this.colFirst, byArray, 2);
        int n = 4;
        int n2 = 0;
        boolean bl = false;
        byte[] byArray2 = new byte[4];
        for (int i2 = 0; i2 < this.rknumbers.length; ++i2) {
            IntegerHelper.getTwoBytes(this.xfIndices[i2], byArray, n);
            n2 = this.rknumbers[i2] << 2;
            IntegerHelper.getFourBytes(n2 |= 2, byArray, n + 2);
            n += 6;
        }
        IntegerHelper.getTwoBytes(this.colLast, byArray, n);
        return byArray;
    }
}

