/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class PaneRecord
extends WritableRecordData {
    private int rowsVisible;
    private int columnsVisible;
    private static final int topLeftPane = 3;
    private static final int bottomLeftPane = 2;
    private static final int topRightPane = 1;
    private static final int bottomRightPane = 0;

    public PaneRecord(int n, int n2) {
        super(Type.PANE);
        this.rowsVisible = n2;
        this.columnsVisible = n;
    }

    public final byte[] getData() {
        byte[] byArray = new byte[10];
        IntegerHelper.getTwoBytes(this.columnsVisible, byArray, 0);
        IntegerHelper.getTwoBytes(this.rowsVisible, byArray, 2);
        if (this.rowsVisible > 0) {
            IntegerHelper.getTwoBytes(this.rowsVisible, byArray, 4);
        }
        if (this.columnsVisible > 0) {
            IntegerHelper.getTwoBytes(this.columnsVisible, byArray, 6);
        }
        int n = 3;
        if (this.rowsVisible > 0 && this.columnsVisible == 0) {
            n = 2;
        } else if (this.rowsVisible == 0 && this.columnsVisible > 0) {
            n = 1;
        } else if (this.rowsVisible > 0 && this.columnsVisible > 0) {
            n = 0;
        }
        IntegerHelper.getTwoBytes(n, byArray, 8);
        return byArray;
    }
}

