/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.EncodedURLHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.biff.SupbookRecord$SupbookType;

class SupbookRecord
extends WritableRecordData {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$SupbookRecord == null ? (class$jxl$write$biff$SupbookRecord = SupbookRecord.class$("jxl.write.biff.SupbookRecord")) : class$jxl$write$biff$SupbookRecord);
    private SupbookRecord$SupbookType type;
    private byte[] data;
    private int numSheets;
    private String fileName;
    private String[] sheetNames;
    private WorkbookSettings workbookSettings;
    public static final SupbookRecord$SupbookType INTERNAL = new SupbookRecord$SupbookType(null);
    public static final SupbookRecord$SupbookType EXTERNAL = new SupbookRecord$SupbookType(null);
    public static final SupbookRecord$SupbookType ADDIN = new SupbookRecord$SupbookType(null);
    public static final SupbookRecord$SupbookType LINK = new SupbookRecord$SupbookType(null);
    public static final SupbookRecord$SupbookType UNKNOWN = new SupbookRecord$SupbookType(null);
    static Class class$jxl$write$biff$SupbookRecord;

    public SupbookRecord(int n, WorkbookSettings workbookSettings) {
        super(Type.SUPBOOK);
        this.numSheets = n;
        this.type = INTERNAL;
        this.workbookSettings = workbookSettings;
    }

    public SupbookRecord(String string, WorkbookSettings workbookSettings) {
        super(Type.SUPBOOK);
        this.fileName = string;
        this.numSheets = 1;
        this.sheetNames = new String[0];
        this.workbookSettings = workbookSettings;
        this.type = EXTERNAL;
    }

    public SupbookRecord(jxl.read.biff.SupbookRecord supbookRecord, WorkbookSettings workbookSettings) {
        super(Type.SUPBOOK);
        this.workbookSettings = workbookSettings;
        if (supbookRecord.getType() == jxl.read.biff.SupbookRecord.INTERNAL) {
            this.type = INTERNAL;
            this.numSheets = supbookRecord.getNumberOfSheets();
        } else if (supbookRecord.getType() == jxl.read.biff.SupbookRecord.EXTERNAL) {
            this.type = EXTERNAL;
            this.numSheets = supbookRecord.getNumberOfSheets();
            this.fileName = supbookRecord.getFileName();
            this.sheetNames = new String[this.numSheets];
            for (int i2 = 0; i2 < this.numSheets; ++i2) {
                this.sheetNames[i2] = supbookRecord.getSheetName(i2);
            }
        }
    }

    private void initInternal(jxl.read.biff.SupbookRecord supbookRecord) {
        this.numSheets = supbookRecord.getNumberOfSheets();
        this.initInternal();
    }

    private void initInternal() {
        this.data = new byte[4];
        IntegerHelper.getTwoBytes(this.numSheets, this.data, 0);
        this.data[2] = 1;
        this.data[3] = 4;
        this.type = INTERNAL;
    }

    final void adjustInternal(int n) {
        Assert.verify(this.type == INTERNAL);
        this.numSheets = n;
        this.initInternal();
    }

    private void initExternal() {
        int n = 0;
        for (int i2 = 0; i2 < this.numSheets; ++i2) {
            n += this.sheetNames[i2].length();
        }
        byte[] byArray = EncodedURLHelper.getEncodedURL(this.fileName, this.workbookSettings);
        int n2 = 6 + byArray.length + this.numSheets * 3 + n * 2;
        this.data = new byte[n2];
        IntegerHelper.getTwoBytes(this.numSheets, this.data, 0);
        int n3 = 2;
        IntegerHelper.getTwoBytes(byArray.length + 1, this.data, n3);
        this.data[n3 + 2] = 0;
        this.data[n3 + 3] = 1;
        System.arraycopy(byArray, 0, this.data, n3 + 4, byArray.length);
        n3 += 4 + byArray.length;
        for (int i3 = 0; i3 < this.sheetNames.length; ++i3) {
            IntegerHelper.getTwoBytes(this.sheetNames[i3].length(), this.data, n3);
            this.data[n3 + 2] = 1;
            StringHelper.getUnicodeBytes(this.sheetNames[i3], this.data, n3 + 3);
            n3 += 3 + this.sheetNames[i3].length() * 2;
        }
    }

    public final byte[] getData() {
        if (this.type == INTERNAL) {
            this.initInternal();
        } else if (this.type == EXTERNAL) {
            this.initExternal();
        } else {
            logger.warn("unsupported supbook type - defaulting to internal");
            this.initInternal();
        }
        return this.data;
    }

    public final SupbookRecord$SupbookType getType() {
        return this.type;
    }

    public final int getNumberOfSheets() {
        return this.numSheets;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getSheetIndex(String string) {
        boolean bl = false;
        int n = 0;
        for (int i2 = 0; i2 < this.sheetNames.length && !bl; ++i2) {
            if (!this.sheetNames[i2].equals(string)) continue;
            bl = true;
            n = 0;
        }
        if (bl) {
            return n;
        }
        String[] stringArray = new String[this.sheetNames.length + 1];
        stringArray[this.sheetNames.length] = string;
        this.sheetNames = stringArray;
        return this.sheetNames.length - 1;
    }

    public final String getSheetName(int n) {
        return this.sheetNames[n];
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

