/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.waitwithstyle;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.java.swingfx.waitwithstyle.CancelableAdaptee;
import net.java.swingfx.waitwithstyle.CancelableProgessAdapter;
import net.java.swingfx.waitwithstyle.InfiniteProgressAdapter;
import net.java.swingfx.waitwithstyle.InfiniteProgressPanel;
import net.java.swingfx.waitwithstyle.PerformanceInfiniteProgressPanel$1;
import net.java.swingfx.waitwithstyle.PerformanceInfiniteProgressPanel$2;
import net.java.swingfx.waitwithstyle.PerformanceInfiniteProgressPanel$3;
import net.java.swingfx.waitwithstyle.PerformanceInfiniteProgressPanel$4;
import net.java.swingfx.waitwithstyle.PerformanceInfiniteProgressPanel$5;

public class PerformanceInfiniteProgressPanel
extends JComponent
implements ActionListener,
CancelableAdaptee {
    private static final int DEFAULT_NUMBER_OF_BARS = 12;
    private int numBars;
    protected InfiniteProgressAdapter infiniteProgressAdapter;
    private double dScale = 1.2;
    private MouseAdapter mouseAdapter = new PerformanceInfiniteProgressPanel$1(this);
    private MouseMotionAdapter mouseMotionAdapter = new PerformanceInfiniteProgressPanel$2(this);
    private KeyAdapter keyAdapter = new PerformanceInfiniteProgressPanel$3(this);
    private ComponentAdapter componentAdapter = new PerformanceInfiniteProgressPanel$4(this);
    private BufferedImage imageBuf = null;
    private Area[] bars;
    private Rectangle barsBounds = null;
    private Rectangle barsScreenBounds = null;
    private AffineTransform centerAndScaleTransform = null;
    private Timer timer = new Timer(250, this);
    private Color[] colors = null;
    private int colorOffset = 0;
    private boolean useBackBuffer;
    private boolean tempHide = false;
    private String text;
    int iterate;

    public PerformanceInfiniteProgressPanel() {
        this(true);
    }

    public PerformanceInfiniteProgressPanel(boolean bl) {
        this(bl, 12);
    }

    public PerformanceInfiniteProgressPanel(int n) {
        this(true, n, null);
    }

    public PerformanceInfiniteProgressPanel(InfiniteProgressAdapter infiniteProgressAdapter) {
        this(true, 12, infiniteProgressAdapter);
    }

    public PerformanceInfiniteProgressPanel(boolean bl, int n) {
        this(bl, n, null);
    }

    public PerformanceInfiniteProgressPanel(boolean bl, InfiniteProgressAdapter infiniteProgressAdapter) {
        this(bl, 12, infiniteProgressAdapter);
    }

    public PerformanceInfiniteProgressPanel(int n, InfiniteProgressAdapter infiniteProgressAdapter) {
        this(true, n, infiniteProgressAdapter);
    }

    public PerformanceInfiniteProgressPanel(boolean bl, int n, InfiniteProgressAdapter infiniteProgressAdapter) {
        int n2;
        this.useBackBuffer = bl;
        this.numBars = n;
        this.setInfiniteProgressAdapter(infiniteProgressAdapter);
        this.colors = new Color[n * 2];
        this.bars = PerformanceInfiniteProgressPanel.buildTicker(n);
        this.barsBounds = new Rectangle();
        for (n2 = 0; n2 < this.bars.length; ++n2) {
            this.barsBounds = this.barsBounds.union(this.bars[n2].getBounds());
        }
        for (n2 = 0; n2 < this.bars.length; ++n2) {
            int n3 = 224 - 128 / (n2 + 1);
            this.colors[n2] = new Color(n3, n3, n3);
            this.colors[n + n2] = this.colors[n2];
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setOpaque(this.useBackBuffer);
    }

    protected final void setInfiniteProgressAdapter(InfiniteProgressAdapter infiniteProgressAdapter) {
        this.infiniteProgressAdapter = infiniteProgressAdapter;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.colorOffset = this.colorOffset == this.numBars - 1 ? 0 : ++this.colorOffset;
        if (this.barsScreenBounds != null) {
            this.repaint(this.barsScreenBounds);
        } else {
            this.repaint();
        }
        if (this.useBackBuffer && this.imageBuf == null) {
            if (this.iterate < 0) {
                try {
                    this.makeSnapshot();
                    this.setOpaque(true);
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                }
            } else {
                --this.iterate;
            }
        }
    }

    public final void setVisible(boolean bl) {
        this.setOpaque(false);
        if (bl) {
            if (this.useBackBuffer) {
                Window window = SwingUtilities.getWindowAncestor(this);
                if (window != null) {
                    window.addComponentListener(this.componentAdapter);
                } else {
                    this.addAncestorListener(new PerformanceInfiniteProgressPanel$5(this));
                }
                this.iterate = 3;
            }
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseMotionAdapter);
            this.addKeyListener(this.keyAdapter);
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.animationStarting();
                this.infiniteProgressAdapter.rampUpEnded();
            }
            this.timer.start();
        } else {
            this.timer.stop();
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.animationStopping();
            }
            this.imageBuf = null;
            this.removeMouseListener(this.mouseAdapter);
            this.removeMouseMotionListener(this.mouseMotionAdapter);
            this.removeKeyListener(this.keyAdapter);
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                window.removeComponentListener(this.componentAdapter);
            }
        }
        super.setVisible(bl);
    }

    private void makeSnapshot() {
        Window window = SwingUtilities.getWindowAncestor(this);
        Insets insets = window.getInsets();
        Rectangle rectangle = new Rectangle(window.getBounds());
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        this.imageBuf = new Robot().createScreenCapture(rectangle);
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.centerAndScaleTransform = new AffineTransform();
        this.centerAndScaleTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        this.centerAndScaleTransform.scale(this.dScale, this.dScale);
        if (this.barsBounds != null) {
            Area area = new Area(this.barsBounds);
            area.transform(this.centerAndScaleTransform);
            this.barsScreenBounds = area.getBounds();
        }
    }

    protected final void paintComponent(Graphics graphics) {
        if (!this.tempHide) {
            Rectangle rectangle = graphics.getClipBounds();
            if (this.imageBuf == null) {
                graphics.setColor(new Color(255, 255, 255, 180));
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.transform(this.centerAndScaleTransform);
            for (int i2 = 0; i2 < this.bars.length; ++i2) {
                graphics2D.setColor(this.colors[i2 + this.colorOffset]);
                graphics2D.fill(this.bars[i2]);
            }
            double d2 = InfiniteProgressPanel.drawTextAt(this.text, this.getFont(), graphics2D, this.getWidth(), this.barsScreenBounds.getMaxY(), this.getForeground());
            if (this.infiniteProgressAdapter != null) {
                this.infiniteProgressAdapter.paintSubComponents(d2);
            }
        }
    }

    private static Area[] buildTicker(int n) {
        Area[] areaArray = new Area[n];
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d2 = Math.PI * 2 / (double)n;
        for (double d3 = 0.0; d3 < (double)n; d3 += 1.0) {
            Area area = PerformanceInfiniteProgressPanel.buildPrimitive();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(double_.getX(), double_.getY());
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(45.0, -6.0);
            AffineTransform affineTransform3 = AffineTransform.getRotateInstance(-d3 * d2, double_.getX(), double_.getY());
            AffineTransform affineTransform4 = new AffineTransform();
            affineTransform4.concatenate(affineTransform);
            affineTransform4.concatenate(affineTransform2);
            area.transform(affineTransform4);
            area.transform(affineTransform3);
            areaArray[(int)d3] = area;
        }
        return areaArray;
    }

    private static Area buildPrimitive() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(6.0, 0.0, 30.0, 12.0);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(0.0, 0.0, 12.0, 12.0);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(30.0, 0.0, 12.0, 12.0);
        Area area = new Area(double_);
        area.add(new Area(double_2));
        area.add(new Area(double_3));
        return area;
    }

    public final void start() {
        this.setVisible(true);
    }

    public final void stop() {
        this.setVisible(false);
    }

    public final void setText(String string) {
        this.text = string;
        this.repaint();
    }

    public final String getText() {
        return this.text;
    }

    public final JComponent getComponent() {
        return this;
    }

    public final void addCancelListener(ActionListener actionListener) {
        if (!(this.infiniteProgressAdapter instanceof CancelableProgessAdapter)) {
            throw new RuntimeException("Expected CancelableProgessAdapter for cancel listener.  Adapter is " + this.infiniteProgressAdapter);
        }
        ((CancelableProgessAdapter)this.infiniteProgressAdapter).addCancelListener(actionListener);
    }

    public final void removeCancelListener(ActionListener actionListener) {
        if (!(this.infiniteProgressAdapter instanceof CancelableProgessAdapter)) {
            throw new RuntimeException("Expected CancelableProgessAdapter for cancel listener.  Adapter is " + this.infiniteProgressAdapter);
        }
        ((CancelableProgessAdapter)this.infiniteProgressAdapter).removeCancelListener(actionListener);
    }

    static final boolean access$000(PerformanceInfiniteProgressPanel performanceInfiniteProgressPanel) {
        return performanceInfiniteProgressPanel.useBackBuffer;
    }

    static final BufferedImage access$102(PerformanceInfiniteProgressPanel performanceInfiniteProgressPanel, BufferedImage bufferedImage) {
        performanceInfiniteProgressPanel.imageBuf = bufferedImage;
        return performanceInfiniteProgressPanel.imageBuf;
    }

    static final ComponentAdapter access$200(PerformanceInfiniteProgressPanel performanceInfiniteProgressPanel) {
        return performanceInfiniteProgressPanel.componentAdapter;
    }
}

