/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class BetaDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -1221965979403477668L;
    private final double alpha;
    private final double beta;
    private double z;
    private final double solverAbsoluteAccuracy;

    public BetaDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public BetaDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public BetaDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        this.alpha = d2;
        this.beta = d3;
        this.z = Double.NaN;
        this.solverAbsoluteAccuracy = d4;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final double getBeta() {
        return this.beta;
    }

    private void recomputeZ() {
        if (Double.isNaN(this.z)) {
            this.z = Gamma.logGamma(this.alpha) + Gamma.logGamma(this.beta) - Gamma.logGamma(this.alpha + this.beta);
        }
    }

    public final double density(double d2) {
        this.recomputeZ();
        if (d2 < 0.0 || d2 > 1.0) {
            return 0.0;
        }
        if (d2 == 0.0) {
            if (this.alpha < 1.0) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.CANNOT_COMPUTE_BETA_DENSITY_AT_0_FOR_SOME_ALPHA, (Number)this.alpha, 1, false);
            }
            return 0.0;
        }
        if (d2 == 1.0) {
            if (this.beta < 1.0) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.CANNOT_COMPUTE_BETA_DENSITY_AT_1_FOR_SOME_BETA, (Number)this.beta, 1, false);
            }
            return 0.0;
        }
        double d3 = FastMath.log(d2);
        double d4 = FastMath.log1p(-d2);
        return FastMath.exp((this.alpha - 1.0) * d3 + (this.beta - 1.0) * d4 - this.z);
    }

    public final double cumulativeProbability(double d2) {
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            return 1.0;
        }
        return Beta.regularizedBeta(d2, this.alpha, this.beta);
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        double d2 = this.getAlpha();
        return d2 / (d2 + this.getBeta());
    }

    public final double getNumericalVariance() {
        double d2 = this.getAlpha();
        double d3 = this.getBeta();
        double d4 = d2 + d3;
        return d2 * d3 / (d4 * d4 * (d4 + 1.0));
    }

    public final double getSupportLowerBound() {
        return 0.0;
    }

    public final double getSupportUpperBound() {
        return 1.0;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

