/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.ResizableDoubleArray;

public class ExponentialDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private static final double[] EXPONENTIAL_SA_QI;
    private final double mean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistribution(double d2) {
        this(d2, 1.0E-9);
    }

    public ExponentialDistribution(double d2, double d3) {
        this(new Well19937c(), d2, d3);
    }

    public ExponentialDistribution(RandomGenerator randomGenerator, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d2);
        }
        this.mean = d2;
        this.solverAbsoluteAccuracy = d3;
    }

    public final double getMean() {
        return this.mean;
    }

    public final double density(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        return FastMath.exp(-d2 / this.mean) / this.mean;
    }

    public final double cumulativeProbability(double d2) {
        double d3 = d2 <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-d2 / this.mean);
        return d3;
    }

    public final double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0.0, 1.0);
        }
        double d3 = d2 == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - d2);
        return d3;
    }

    public final double sample() {
        double d2;
        double d3;
        double d4 = 0.0;
        for (d3 = this.random.nextDouble(); d3 < 0.5; d3 *= 2.0) {
            d4 += EXPONENTIAL_SA_QI[0];
        }
        if ((d3 += d3 - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return this.mean * (d4 + d3);
        }
        int n = 0;
        double d5 = d2 = this.random.nextDouble();
        do {
            ++n;
            d2 = this.random.nextDouble();
            if (!(d2 < d5)) continue;
            d5 = d2;
        } while (d3 > EXPONENTIAL_SA_QI[n]);
        return this.mean * (d4 + d5 * EXPONENTIAL_SA_QI[0]);
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        return this.getMean();
    }

    public final double getNumericalVariance() {
        double d2 = this.getMean();
        return d2 * d2;
    }

    public final double getSupportLowerBound() {
        return 0.0;
    }

    public final double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }

    static {
        double d2 = FastMath.log(2.0);
        double d3 = 0.0;
        int n = 1;
        ResizableDoubleArray resizableDoubleArray = new ResizableDoubleArray(20);
        while (d3 < 1.0) {
            resizableDoubleArray.addElement(d3 += FastMath.pow(d2, n) / (double)ArithmeticUtils.factorial(n));
            ++n;
        }
        EXPONENTIAL_SA_QI = resizableDoubleArray.getElements();
    }
}

