/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.SaddlePointExpansion;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final ExponentialDistribution exponential;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double d2) {
        this(d2, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double d2, double d3, int n) {
        this(new Well19937c(), d2, d3, n);
    }

    public PoissonDistribution(RandomGenerator randomGenerator, double d2, double d3, int n) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d2);
        }
        this.mean = d2;
        this.epsilon = d3;
        this.maxIterations = n;
        this.normal = new NormalDistribution(randomGenerator, d2, FastMath.sqrt(d2), 1.0E-9);
        this.exponential = new ExponentialDistribution(randomGenerator, 1.0, 1.0E-9);
    }

    public PoissonDistribution(double d2, double d3) {
        this(d2, d3, 10000000);
    }

    public PoissonDistribution(double d2, int n) {
        this(d2, 1.0E-12, n);
    }

    public final double getMean() {
        return this.mean;
    }

    public final double probability(int n) {
        double d2 = n < 0 || n == Integer.MAX_VALUE ? 0.0 : (n == 0 ? FastMath.exp(-this.mean) : FastMath.exp(-SaddlePointExpansion.getStirlingError(n) - SaddlePointExpansion.getDeviancePart(n, this.mean)) / FastMath.sqrt(Math.PI * 2 * (double)n));
        return d2;
    }

    public final double cumulativeProbability(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)n + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public final double normalApproximateProbability(int n) {
        return this.normal.cumulativeProbability((double)n + 0.5);
    }

    public final double getNumericalMean() {
        return this.getMean();
    }

    public final double getNumericalVariance() {
        return this.getMean();
    }

    public final int getSupportLowerBound() {
        return 0;
    }

    public final int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public final boolean isSupportConnected() {
        return true;
    }

    public final int sample() {
        return (int)FastMath.min(this.nextPoisson(this.mean), Integer.MAX_VALUE);
    }

    private long nextPoisson(double d2) {
        double d3;
        long l2;
        block9: {
            double d4 = 40.0;
            if (d2 < 40.0) {
                double d5 = FastMath.exp(-d2);
                long l3 = 0L;
                double d6 = 1.0;
                double d7 = 1.0;
                while ((double)l3 < 1000.0 * d2) {
                    d7 = this.random.nextDouble();
                    if ((d6 *= d7) >= d5) {
                        ++l3;
                        continue;
                    }
                    return l3;
                }
                return l3;
            }
            double d8 = FastMath.floor(d2);
            double d9 = d2 - d8;
            double d10 = FastMath.log(d8);
            double d11 = ArithmeticUtils.factorialLog((int)d8);
            l2 = d9 < Double.MIN_VALUE ? 0L : this.nextPoisson(d9);
            double d12 = FastMath.sqrt(d8 * FastMath.log(32.0 * d8 / Math.PI + 1.0));
            double d13 = d12 / 2.0;
            double d14 = 2.0 * d8 + d12;
            double d15 = FastMath.sqrt(Math.PI * d14) * FastMath.exp(0.0 * d8);
            double d16 = d14 / d12 * FastMath.exp(-d12 * (1.0 + d12) / d14);
            double d17 = d15 + d16 + 1.0;
            double d18 = d15 / d17;
            double d19 = d16 / d17;
            double d20 = 1.0 / (8.0 * d8);
            double d21 = 0.0;
            d3 = 0.0;
            double d22 = 0.0;
            boolean bl = false;
            double d23 = 0.0;
            double d24 = 0.0;
            double d25 = 0.0;
            while (true) {
                double d26;
                if ((d26 = this.random.nextDouble()) <= d18) {
                    double d27 = this.random.nextGaussian();
                    d21 = d27 * FastMath.sqrt(d8 + d13) - 0.5;
                    if (d21 > d12 || d21 < -d8) continue;
                    d3 = d21 < 0.0 ? FastMath.floor(d21) : FastMath.ceil(d21);
                    double d28 = this.exponential.sample();
                    d22 = -d28 - d27 * d27 / 2.0 + d20;
                } else {
                    if (d26 > d18 + d19) {
                        d3 = d8;
                        break block9;
                    }
                    d21 = d12 + d14 / d12 * this.exponential.sample();
                    d3 = FastMath.ceil(d21);
                    d22 = -this.exponential.sample() - d12 * (d21 + 1.0) / d14;
                }
                bl = d21 < 0.0;
                d23 = d3 * (d3 + 1.0) / (2.0 * d8);
                if (d22 < -d23 && !bl) {
                    d3 = d8 + d3;
                    break block9;
                }
                d24 = d23 * ((2.0 * d3 + 1.0) / (6.0 * d8) - 1.0);
                d25 = d24 - d23 * d23 / (3.0 * (d8 + (double)bl * (d3 + 1.0)));
                if (d22 < d25) {
                    d3 = d8 + d3;
                    break block9;
                }
                if (!(d22 > d24) && d22 < d3 * d10 - ArithmeticUtils.factorialLog((int)(d3 + d8)) + d11) break;
            }
            d3 = d8 + d3;
        }
        return l2 + (long)d3;
    }
}

