/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public final class ArithmeticUtils {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final AtomicReference STIRLING_S2 = new AtomicReference<Object>(null);

    private ArithmeticUtils() {
    }

    public static final int addAndCheck(int n, int n2) {
        long l2 = (long)n + (long)n2;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, n, n2);
        }
        return (int)l2;
    }

    public static final long addAndCheck(long l2, long l3) {
        return ArithmeticUtils.addAndCheck(l2, l3, LocalizedFormats.OVERFLOW_IN_ADDITION);
    }

    public static final long binomialCoefficient(int n, int n2) {
        ArithmeticUtils.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 1L;
        }
        if (n2 == 1 || n2 == n - 1) {
            return n;
        }
        if (n2 > n / 2) {
            return ArithmeticUtils.binomialCoefficient(n, n - n2);
        }
        long l2 = 1L;
        if (n <= 61) {
            int n3 = n - n2 + 1;
            for (int i2 = 1; i2 <= n2; ++i2) {
                l2 = l2 * (long)n3 / (long)i2;
                ++n3;
            }
        } else if (n <= 66) {
            int n4 = n - n2 + 1;
            for (int i3 = 1; i3 <= n2; ++i3) {
                long l3 = ArithmeticUtils.gcd(n4, i3);
                l2 = l2 / ((long)i3 / l3) * ((long)n4 / l3);
                ++n4;
            }
        } else {
            int n5 = n - n2 + 1;
            for (int i4 = 1; i4 <= n2; ++i4) {
                long l4 = ArithmeticUtils.gcd(n5, i4);
                l2 = ArithmeticUtils.mulAndCheck(l2 / ((long)i4 / l4), (long)n5 / l4);
                ++n5;
            }
        }
        return l2;
    }

    public static final double binomialCoefficientDouble(int n, int n2) {
        ArithmeticUtils.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 1.0;
        }
        if (n2 == 1 || n2 == n - 1) {
            return n;
        }
        if (n2 > n / 2) {
            return ArithmeticUtils.binomialCoefficientDouble(n, n - n2);
        }
        if (n < 67) {
            return ArithmeticUtils.binomialCoefficient(n, n2);
        }
        double d2 = 1.0;
        for (int i2 = 1; i2 <= n2; ++i2) {
            d2 *= (double)(n - n2 + i2) / (double)i2;
        }
        return FastMath.floor(d2 + 0.5);
    }

    public static final double binomialCoefficientLog(int n, int n2) {
        int n3;
        ArithmeticUtils.checkBinomial(n, n2);
        if (n == n2 || n2 == 0) {
            return 0.0;
        }
        if (n2 == 1 || n2 == n - 1) {
            return FastMath.log(n);
        }
        if (n < 67) {
            return FastMath.log(ArithmeticUtils.binomialCoefficient(n, n2));
        }
        if (n < 1030) {
            return FastMath.log(ArithmeticUtils.binomialCoefficientDouble(n, n2));
        }
        if (n2 > n / 2) {
            return ArithmeticUtils.binomialCoefficientLog(n, n - n2);
        }
        double d2 = 0.0;
        for (n3 = n - n2 + 1; n3 <= n; ++n3) {
            d2 += FastMath.log(n3);
        }
        for (n3 = 2; n3 <= n2; ++n3) {
            d2 -= FastMath.log(n3);
        }
        return d2;
    }

    public static final long factorial(int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
        }
        if (n > 20) {
            throw new MathArithmeticException();
        }
        return FACTORIALS[n];
    }

    public static final double factorialDouble(int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
        }
        if (n < 21) {
            return FACTORIALS[n];
        }
        return FastMath.floor(FastMath.exp(ArithmeticUtils.factorialLog(n)) + 0.5);
    }

    public static final double factorialLog(int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n);
        }
        if (n < 21) {
            return FastMath.log(FACTORIALS[n]);
        }
        double d2 = 0.0;
        for (int i2 = 2; i2 <= n; ++i2) {
            d2 += FastMath.log(i2);
        }
        return d2;
    }

    public static final int gcd(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n3 == 0 || n4 == 0) {
            if (n3 == Integer.MIN_VALUE || n4 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, n, n2);
            }
            return FastMath.abs(n3 + n4);
        }
        long l2 = n3;
        long l3 = n4;
        boolean bl = false;
        if (n3 < 0) {
            if (Integer.MIN_VALUE == n3) {
                bl = true;
            } else {
                n3 = -n3;
            }
            l2 = -l2;
        }
        if (n4 < 0) {
            if (Integer.MIN_VALUE == n4) {
                bl = true;
            } else {
                n4 = -n4;
            }
            l3 = -l3;
        }
        if (bl) {
            if (l2 == l3) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, n, n2);
            }
            long l4 = l3;
            l3 = l2;
            if ((l2 = l4 % l2) == 0L) {
                if (l3 > Integer.MAX_VALUE) {
                    throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, n, n2);
                }
                return (int)l3;
            }
            l4 = l3;
            n4 = (int)l2;
            n3 = (int)(l4 % l2);
        }
        return ArithmeticUtils.gcdPositive(n3, n4);
    }

    private static int gcdPositive(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int n3 = Integer.numberOfTrailingZeros(n);
        n >>= n3;
        int n4 = Integer.numberOfTrailingZeros(n2);
        n2 >>= n4;
        int n5 = Math.min(n3, n4);
        while (n != n2) {
            int n6 = n - n2;
            n2 = Math.min(n, n2);
            n = Math.abs(n6);
            n >>= Integer.numberOfTrailingZeros(n);
        }
        return n << n5;
    }

    public static final long gcd(long l2, long l3) {
        long l4;
        int n;
        long l5 = l2;
        long l6 = l3;
        if (l5 == 0L || l6 == 0L) {
            if (l5 == Long.MIN_VALUE || l6 == Long.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, l2, l3);
            }
            return FastMath.abs(l5) + FastMath.abs(l6);
        }
        if (l5 > 0L) {
            l5 = -l5;
        }
        if (l6 > 0L) {
            l6 = -l6;
        }
        for (n = 0; (l5 & 1L) == 0L && (l6 & 1L) == 0L && n < 63; ++n) {
            l5 /= 2L;
            l6 /= 2L;
        }
        if (n == 63) {
            throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, l2, l3);
        }
        long l7 = l4 = (l5 & 1L) == 1L ? l6 : -(l5 / 2L);
        while (true) {
            if ((l4 & 1L) == 0L) {
                l4 /= 2L;
                continue;
            }
            if (l4 > 0L) {
                l5 = -l4;
            } else {
                l6 = l4;
            }
            if ((l4 = (l6 - l5) / 2L) == 0L) break;
        }
        return -l5 * (1L << n);
    }

    public static final int lcm(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        int n3 = FastMath.abs(ArithmeticUtils.mulAndCheck(n / ArithmeticUtils.gcd(n, n2), n2));
        if (n3 == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.LCM_OVERFLOW_32_BITS, n, n2);
        }
        return n3;
    }

    public static final long lcm(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        long l4 = FastMath.abs(ArithmeticUtils.mulAndCheck(l2 / ArithmeticUtils.gcd(l2, l3), l3));
        if (l4 == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.LCM_OVERFLOW_64_BITS, l2, l3);
        }
        return l4;
    }

    public static final int mulAndCheck(int n, int n2) {
        long l2 = (long)n * (long)n2;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException();
        }
        return (int)l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long mulAndCheck(long l2, long l3) {
        if (l2 > l3) {
            return ArithmeticUtils.mulAndCheck(l3, l2);
        }
        if (l2 < 0L) {
            if (l3 < 0L) {
                if (l2 < Long.MAX_VALUE / l3) throw new MathArithmeticException();
                return l2 * l3;
            }
            if (l3 <= 0L) return 0L;
            if (Long.MIN_VALUE / l3 > l2) throw new MathArithmeticException();
            return l2 * l3;
        }
        if (l2 <= 0L) return 0L;
        if (l2 > Long.MAX_VALUE / l3) throw new MathArithmeticException();
        return l2 * l3;
    }

    public static final int subAndCheck(int n, int n2) {
        long l2 = (long)n - (long)n2;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, n, n2);
        }
        return (int)l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long subAndCheck(long l2, long l3) {
        if (l3 != Long.MIN_VALUE) return ArithmeticUtils.addAndCheck(l2, -l3, LocalizedFormats.OVERFLOW_IN_ADDITION);
        if (l2 >= 0L) throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, l2, -l3);
        return l2 - l3;
    }

    public static final int pow(int n, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, n2);
        }
        int n3 = 1;
        int n4 = n;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 *= n4;
            }
            n4 *= n4;
            n2 >>= 1;
        }
        return n3;
    }

    public static final int pow(int n, long l2) {
        if (l2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, l2);
        }
        int n2 = 1;
        int n3 = n;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                n2 *= n3;
            }
            n3 *= n3;
            l2 >>= 1;
        }
        return n2;
    }

    public static final long pow(long l2, int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, n);
        }
        long l3 = 1L;
        long l4 = l2;
        while (n != 0) {
            if ((n & 1) != 0) {
                l3 *= l4;
            }
            l4 *= l4;
            n >>= 1;
        }
        return l3;
    }

    public static final long pow(long l2, long l3) {
        if (l3 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, l3);
        }
        long l4 = 1L;
        long l5 = l2;
        while (l3 != 0L) {
            if ((l3 & 1L) != 0L) {
                l4 *= l5;
            }
            l5 *= l5;
            l3 >>= 1;
        }
        return l4;
    }

    public static final BigInteger pow(BigInteger bigInteger, int n) {
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, n);
        }
        return bigInteger.pow(n);
    }

    public static final BigInteger pow(BigInteger bigInteger, long l2) {
        if (l2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, l2);
        }
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = bigInteger;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                bigInteger2 = bigInteger2.multiply(bigInteger3);
            }
            bigInteger3 = bigInteger3.multiply(bigInteger3);
            l2 >>= 1;
        }
        return bigInteger2;
    }

    public static final BigInteger pow(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, bigInteger2);
        }
        BigInteger bigInteger3 = BigInteger.ONE;
        BigInteger bigInteger4 = bigInteger;
        while (!BigInteger.ZERO.equals(bigInteger2)) {
            if (bigInteger2.testBit(0)) {
                bigInteger3 = bigInteger3.multiply(bigInteger4);
            }
            bigInteger4 = bigInteger4.multiply(bigInteger4);
            bigInteger2 = bigInteger2.shiftRight(1);
        }
        return bigInteger3;
    }

    public static final long stirlingS2(int n, int n2) {
        if (n2 < 0) {
            throw new NotPositiveException(n2);
        }
        if (n2 > n) {
            throw new NumberIsTooLargeException(n2, (Number)n, true);
        }
        Object object = (long[][])STIRLING_S2.get();
        if (object == null) {
            int n3 = 26;
            object = new long[26][];
            object[0] = new long[]{1L};
            for (int i2 = 1; i2 < ((long[][])object).length; ++i2) {
                object[i2] = new long[i2 + 1];
                object[i2][0] = 0L;
                object[i2][1] = 1L;
                object[i2][i2] = 1L;
                for (int i3 = 2; i3 < i2; ++i3) {
                    object[i2][i3] = (long)i3 * object[i2 - 1][i3] + object[i2 - 1][i3 - 1];
                }
            }
            STIRLING_S2.compareAndSet(null, object);
        }
        if (n < ((long[][])object).length) {
            return object[n][n2];
        }
        if (n2 == 0) {
            return 0L;
        }
        if (n2 == 1 || n2 == n) {
            return 1L;
        }
        if (n2 == 2) {
            return (1L << n - 1) - 1L;
        }
        if (n2 == n - 1) {
            return ArithmeticUtils.binomialCoefficient(n, 2);
        }
        long l2 = 0L;
        long l3 = (n2 & 1) == 0 ? 1L : -1L;
        for (int i4 = 1; i4 <= n2; ++i4) {
            if ((l2 += (l3 = -l3) * ArithmeticUtils.binomialCoefficient(n2, i4) * (long)ArithmeticUtils.pow(i4, n)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n, 0, ((long[][])object).length - 1);
        }
        return l2 / ArithmeticUtils.factorial(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long addAndCheck(long l2, long l3, Localizable localizable) {
        if (l2 > l3) {
            return ArithmeticUtils.addAndCheck(l3, l2, localizable);
        }
        if (l2 < 0L) {
            if (l3 >= 0L) return l2 + l3;
            if (Long.MIN_VALUE - l3 > l2) throw new MathArithmeticException(localizable, l2, l3);
            return l2 + l3;
        }
        if (l2 > Long.MAX_VALUE - l3) throw new MathArithmeticException(localizable, l2, l3);
        return l2 + l3;
    }

    private static void checkBinomial(int n, int n2) {
        if (n < n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, (Number)n2, n, true);
        }
        if (n < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n);
        }
    }

    public static final boolean isPowerOfTwo(long l2) {
        return l2 > 0L && (l2 & l2 - 1L) == 0L;
    }
}

