/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.math.BigDecimal;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public class Precision {
    public static final double EPSILON = Double.longBitsToDouble(4368491638549381120L);
    public static final double SAFE_MIN = Double.longBitsToDouble(0x10000000000000L);
    private static final long EXPONENT_OFFSET = 1023L;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;

    private Precision() {
    }

    public static final int compareTo(double d2, double d3, double d4) {
        if (Precision.equals(d2, d3, d4)) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    public static final int compareTo(double d2, double d3, int n) {
        if (Precision.equals(d2, d3, n)) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    public static final boolean equals(float f2, float f3) {
        return Precision.equals(f2, f3, 1);
    }

    public static final boolean equalsIncludingNaN(float f2, float f3) {
        return Float.isNaN(f2) && Float.isNaN(f3) || Precision.equals(f2, f3, 1);
    }

    public static final boolean equals(float f2, float f3, float f4) {
        return Precision.equals(f2, f3, 1) || FastMath.abs(f3 - f2) <= f4;
    }

    public static final boolean equalsIncludingNaN(float f2, float f3, float f4) {
        return Precision.equalsIncludingNaN(f2, f3) || FastMath.abs(f3 - f2) <= f4;
    }

    public static final boolean equals(float f2, float f3, int n) {
        int n2 = Float.floatToIntBits(f2);
        int n3 = Float.floatToIntBits(f3);
        if (n2 < 0) {
            n2 = Integer.MIN_VALUE - n2;
        }
        if (n3 < 0) {
            n3 = Integer.MIN_VALUE - n3;
        }
        boolean bl = FastMath.abs(n2 - n3) <= n;
        return bl && !Float.isNaN(f2) && !Float.isNaN(f3);
    }

    public static final boolean equalsIncludingNaN(float f2, float f3, int n) {
        return Float.isNaN(f2) && Float.isNaN(f3) || Precision.equals(f2, f3, n);
    }

    public static final boolean equals(double d2, double d3) {
        return Precision.equals(d2, d3, 1);
    }

    public static final boolean equalsIncludingNaN(double d2, double d3) {
        return Double.isNaN(d2) && Double.isNaN(d3) || Precision.equals(d2, d3, 1);
    }

    public static final boolean equals(double d2, double d3, double d4) {
        return Precision.equals(d2, d3, 1) || FastMath.abs(d3 - d2) <= d4;
    }

    public static final boolean equalsWithRelativeTolerance(double d2, double d3, double d4) {
        if (Precision.equals(d2, d3, 1)) {
            return true;
        }
        double d5 = FastMath.max(FastMath.abs(d2), FastMath.abs(d3));
        double d6 = FastMath.abs((d2 - d3) / d5);
        return d6 <= d4;
    }

    public static final boolean equalsIncludingNaN(double d2, double d3, double d4) {
        return Precision.equalsIncludingNaN(d2, d3) || FastMath.abs(d3 - d2) <= d4;
    }

    public static final boolean equals(double d2, double d3, int n) {
        long l2 = Double.doubleToLongBits(d2);
        long l3 = Double.doubleToLongBits(d3);
        if (l2 < 0L) {
            l2 = Long.MIN_VALUE - l2;
        }
        if (l3 < 0L) {
            l3 = Long.MIN_VALUE - l3;
        }
        boolean bl = FastMath.abs(l2 - l3) <= (long)n;
        return bl && !Double.isNaN(d2) && !Double.isNaN(d3);
    }

    public static final boolean equalsIncludingNaN(double d2, double d3, int n) {
        return Double.isNaN(d2) && Double.isNaN(d3) || Precision.equals(d2, d3, n);
    }

    public static final double round(double d2, int n) {
        return Precision.round(d2, n, 4);
    }

    public static final double round(double d2, int n, int n2) {
        try {
            return new BigDecimal(Double.toString(d2)).setScale(n, n2).doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d2)) {
                return d2;
            }
            return Double.NaN;
        }
    }

    public static final float round(float f2, int n) {
        return Precision.round(f2, n, 4);
    }

    public static final float round(float f2, int n, int n2) {
        float f3 = FastMath.copySign(1.0f, f2);
        float f4 = (float)FastMath.pow(10.0, n) * f3;
        return (float)Precision.roundUnscaled(f2 * f4, f3, n2) / f4;
    }

    private static double roundUnscaled(double d2, double d3, int n) {
        switch (n) {
            case 2: {
                if (d3 == -1.0) {
                    d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                    break;
                }
                d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                break;
            }
            case 1: {
                d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                break;
            }
            case 3: {
                if (d3 == -1.0) {
                    d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                    break;
                }
                d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                break;
            }
            case 5: {
                d2 = FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY);
                double d4 = d2 - FastMath.floor(d2);
                if (d4 > 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                d2 = FastMath.floor(d2);
                break;
            }
            case 6: {
                double d5 = d2 - FastMath.floor(d2);
                if (d5 > 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                if (d5 < 0.5) {
                    d2 = FastMath.floor(d2);
                    break;
                }
                if (FastMath.floor(d2) / 2.0 == FastMath.floor(Math.floor(d2) / 2.0)) {
                    d2 = FastMath.floor(d2);
                    break;
                }
                d2 = FastMath.ceil(d2);
                break;
            }
            case 4: {
                d2 = FastMath.nextAfter(d2, Double.POSITIVE_INFINITY);
                double d6 = d2 - FastMath.floor(d2);
                if (d6 >= 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                d2 = FastMath.floor(d2);
                break;
            }
            case 7: {
                if (d2 == FastMath.floor(d2)) break;
                throw new MathArithmeticException();
            }
            case 0: {
                d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                break;
            }
            default: {
                throw new MathIllegalArgumentException(LocalizedFormats.INVALID_ROUNDING_METHOD, n, "ROUND_CEILING", 2, "ROUND_DOWN", 1, "ROUND_FLOOR", 3, "ROUND_HALF_DOWN", 5, "ROUND_HALF_EVEN", 6, "ROUND_HALF_UP", 4, "ROUND_UNNECESSARY", 7, "ROUND_UP", 0);
            }
        }
        return d2;
    }

    public static final double representableDelta(double d2, double d3) {
        return d2 + d3 - d2;
    }
}

