/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.FileInputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class ECSDefaults {
    private static ECSDefaults defaults = new ECSDefaults();
    private ResourceBundle resource;
    private boolean filter_state = false;
    private boolean filter_attribute_state = false;
    private char attribute_equality_sign = (char)61;
    private char begin_start_modifier = (char)32;
    private char end_start_modifier = (char)32;
    private char begin_end_modifier = (char)32;
    private char end_end_modifier = (char)32;
    private char attribute_quote_char = (char)34;
    private boolean attribute_quote = true;
    private boolean end_element = true;
    private String codeset = "UTF-8";
    private int position = 4;
    private int case_type = 3;
    private char start_tag = (char)60;
    private char end_tag = (char)62;
    private boolean pretty_print = false;

    private ECSDefaults() {
        try {
            String string = System.getProperty("ecs.properties");
            this.resource = string == null ? ResourceBundle.getBundle("org.apache.ecs.ecs") : new PropertyResourceBundle(new FileInputStream(string));
            this.filter_state = new Boolean(this.resource.getString("filter_state"));
            this.filter_attribute_state = new Boolean(this.resource.getString("filter_attribute_state"));
            this.attribute_equality_sign = this.resource.getString("attribute_equality_sign").charAt(1);
            this.begin_start_modifier = this.resource.getString("begin_start_modifier").charAt(1);
            this.end_start_modifier = this.resource.getString("end_start_modifier").charAt(1);
            this.begin_end_modifier = this.resource.getString("begin_end_modifier").charAt(1);
            this.end_end_modifier = this.resource.getString("end_end_modifier").charAt(1);
            this.attribute_quote_char = this.resource.getString("attribute_quote_char").charAt(0);
            this.attribute_quote = new Boolean(this.resource.getString("attribute_quote"));
            this.end_element = new Boolean(this.resource.getString("end_element"));
            this.codeset = this.resource.getString("codeset");
            this.position = Integer.parseInt(this.resource.getString("position"));
            this.case_type = Integer.parseInt(this.resource.getString("case_type"));
            this.start_tag = this.resource.getString("start_tag").charAt(0);
            this.end_tag = this.resource.getString("end_tag").charAt(0);
            this.pretty_print = new Boolean(this.resource.getString("pretty_print"));
        }
        catch (Exception exception) {
            System.err.println("The following error preventing ecs.properties being loaded:");
            System.err.println(exception.toString());
        }
    }

    public static final String debugString() {
        return "ECSDefaults:\n\tDefaultFilterState=" + ECSDefaults.getDefaultFilterState() + '\n' + '\t' + "DefaultFilterAttributeState=" + ECSDefaults.getDefaultFilterAttributeState() + '\n' + '\t' + "DefaultAttributeEqualitySign='" + ECSDefaults.getDefaultAttributeEqualitySign() + "'\n" + '\t' + "DefaultBeginStartModifier='" + ECSDefaults.getDefaultBeginStartModifier() + "'\n" + '\t' + "DefaultEndStartModifier='" + ECSDefaults.getDefaultEndStartModifier() + "'\n" + '\t' + "DefaultBeginEndModifier='" + ECSDefaults.getDefaultBeginEndModifier() + "'\n" + '\t' + "DefaultEndEndModifier='" + ECSDefaults.getDefaultEndEndModifier() + "'\n" + '\t' + "DefaultAttributeQuoteChar=" + ECSDefaults.getDefaultAttributeQuoteChar() + '\n' + '\t' + "DefaultAttributeQuote=" + ECSDefaults.getDefaultAttributeQuote() + '\n' + '\t' + "DefaultEndElement=" + ECSDefaults.getDefaultEndElement() + '\n' + '\t' + "DefaultCodeset='" + ECSDefaults.getDefaultCodeset() + "'\n" + '\t' + "DefaultPosition=" + ECSDefaults.getDefaultPosition() + '\n' + '\t' + "DefaultCaseType=" + ECSDefaults.getDefaultCaseType() + '\n' + '\t' + "DefaultStartTag='" + ECSDefaults.getDefaultStartTag() + "'\n" + '\t' + "DefaultEndTag='" + ECSDefaults.getDefaultEndTag() + "'\n" + '\t' + "DefaultPrettyPrint=" + ECSDefaults.getDefaultPrettyPrint();
    }

    public static final char getDefaultAttributeEqualitySign() {
        return ECSDefaults.defaults.attribute_equality_sign;
    }

    public static final boolean getDefaultAttributeQuote() {
        return ECSDefaults.defaults.attribute_quote;
    }

    public static final char getDefaultAttributeQuoteChar() {
        return ECSDefaults.defaults.attribute_quote_char;
    }

    public static final char getDefaultBeginEndModifier() {
        return ECSDefaults.defaults.begin_end_modifier;
    }

    public static final char getDefaultBeginStartModifier() {
        return ECSDefaults.defaults.begin_start_modifier;
    }

    public static final int getDefaultCaseType() {
        return ECSDefaults.defaults.case_type;
    }

    public static final String getDefaultCodeset() {
        return ECSDefaults.defaults.codeset;
    }

    public static final boolean getDefaultEndElement() {
        return ECSDefaults.defaults.end_element;
    }

    public static final char getDefaultEndEndModifier() {
        return ECSDefaults.defaults.end_end_modifier;
    }

    public static final char getDefaultEndStartModifier() {
        return ECSDefaults.defaults.end_start_modifier;
    }

    public static final char getDefaultEndTag() {
        return ECSDefaults.defaults.end_tag;
    }

    public static final boolean getDefaultFilterAttributeState() {
        return ECSDefaults.defaults.filter_attribute_state;
    }

    public static final boolean getDefaultFilterState() {
        return ECSDefaults.defaults.filter_state;
    }

    public static final int getDefaultPosition() {
        return ECSDefaults.defaults.position;
    }

    public static final boolean getDefaultPrettyPrint() {
        return ECSDefaults.defaults.pretty_print;
    }

    public static final char getDefaultStartTag() {
        return ECSDefaults.defaults.start_tag;
    }
}

