/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.NDC$DiagnosticContext;
import org.apache.log4j.helpers.LogLog;

public class NDC {
    static Hashtable ht = new Hashtable();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    private NDC() {
    }

    public static final void clear() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null) {
            stack.setSize(0);
        }
    }

    public static final Stack cloneStack() {
        Object v = ht.get(Thread.currentThread());
        if (v == null) {
            return null;
        }
        Stack stack = (Stack)v;
        return (Stack)stack.clone();
    }

    public static final void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    public static final String get() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && !stack.isEmpty()) {
            return ((NDC$DiagnosticContext)stack.peek()).fullMessage;
        }
        return null;
    }

    public static final int getDepth() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lazyRemove() {
        Object object;
        Vector<Thread> vector;
        int n;
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            if (++pushCounter <= 5) {
                return;
            }
            pushCounter = 0;
            n = 0;
            vector = new Vector<Thread>();
            object = ht.keys();
            while (object.hasMoreElements() && n <= 4) {
                Thread thread = (Thread)object.nextElement();
                if (thread.isAlive()) {
                    ++n;
                    continue;
                }
                n = 0;
                vector.addElement(thread);
            }
        }
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object = (Thread)vector.elementAt(n);
            LogLog.debug("Lazy NDC removal for thread [" + ((Thread)object).getName() + "] (" + ht.size() + ").");
            ht.remove(object);
        }
    }

    public static final String pop() {
        Thread thread = Thread.currentThread();
        Stack stack = (Stack)ht.get(thread);
        if (stack != null && !stack.isEmpty()) {
            return ((NDC$DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static final String peek() {
        Thread thread = Thread.currentThread();
        Stack stack = (Stack)ht.get(thread);
        if (stack != null && !stack.isEmpty()) {
            return ((NDC$DiagnosticContext)stack.peek()).message;
        }
        return "";
    }

    public static final void push(String string) {
        Thread thread = Thread.currentThread();
        Stack<NDC$DiagnosticContext> stack = (Stack<NDC$DiagnosticContext>)ht.get(thread);
        if (stack == null) {
            NDC$DiagnosticContext nDC$DiagnosticContext = new NDC$DiagnosticContext(string, null);
            stack = new Stack<NDC$DiagnosticContext>();
            ht.put(thread, stack);
            stack.push(nDC$DiagnosticContext);
        } else if (stack.isEmpty()) {
            NDC$DiagnosticContext nDC$DiagnosticContext = new NDC$DiagnosticContext(string, null);
            stack.push(nDC$DiagnosticContext);
        } else {
            NDC$DiagnosticContext nDC$DiagnosticContext = (NDC$DiagnosticContext)stack.peek();
            stack.push(new NDC$DiagnosticContext(string, nDC$DiagnosticContext));
        }
    }

    public static final void remove() {
        ht.remove(Thread.currentThread());
        NDC.lazyRemove();
    }

    public static final void setMaxDepth(int n) {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && n < stack.size()) {
            stack.setSize(n);
        }
    }
}

