/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.dom4j.DocumentFactory;
import org.dom4j.Namespace;
import org.dom4j.tree.QNameCache;

public class QName
implements Serializable {
    protected static transient ThreadLocal cachePerThread = new ThreadLocal();
    private String name;
    private String qualifiedName;
    private transient Namespace namespace;
    private int hashCode;
    private DocumentFactory documentFactory;

    public QName(String string) {
        this(string, Namespace.NO_NAMESPACE);
    }

    public QName(String string, Namespace namespace) {
        this.name = string == null ? "" : string;
        this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
    }

    public QName(String string, Namespace namespace, String string2) {
        this.name = string == null ? "" : string;
        this.qualifiedName = string2;
        this.namespace = namespace == null ? Namespace.NO_NAMESPACE : namespace;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            if (this.hashCode() == qName.hashCode()) {
                return this.getName().equals(qName.getName()) && this.getNamespaceURI().equals(qName.getNamespaceURI());
            }
        }
        return false;
    }

    public static QName get(String string) {
        return QName.getCache().get(string);
    }

    public static QName get(String string, String string2) {
        return QName.getCache().get(string, string2);
    }

    public static QName get(String string, String string2, String string3) {
        return QName.getCache().get(string, Namespace.get(string2, string3));
    }

    public static QName get(String string, Namespace namespace) {
        return QName.getCache().get(string, namespace);
    }

    public static QName get(String string, Namespace namespace, String string2) {
        return QName.getCache().get(string, namespace, string2);
    }

    private static QNameCache getCache() {
        QNameCache qNameCache = (QNameCache)cachePerThread.get();
        if (qNameCache == null) {
            qNameCache = new QNameCache();
            cachePerThread.set(qNameCache);
        }
        return qNameCache;
    }

    public DocumentFactory getDocumentFactory() {
        return this.documentFactory;
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getNamespacePrefix() {
        if (this.namespace == null) {
            return "";
        }
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        if (this.namespace == null) {
            return "";
        }
        return this.namespace.getURI();
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            String string = this.getNamespacePrefix();
            this.qualifiedName = string != null && string.length() > 0 ? String.valueOf(string) + ":" + this.name : this.name;
        }
        return this.qualifiedName;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.getName().hashCode() ^ this.getNamespaceURI().hashCode();
            if (this.hashCode == 0) {
                this.hashCode = 47806;
            }
        }
        return this.hashCode;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        String string = (String)objectInputStream.readObject();
        String string2 = (String)objectInputStream.readObject();
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.get(string, string2);
    }

    public void setDocumentFactory(DocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [name: " + this.getName() + " namespace: \"" + this.getNamespace() + "\"]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
        objectOutputStream.defaultWriteObject();
    }
}

