/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.BackedList;
import org.dom4j.tree.ContentListFacade;
import org.dom4j.tree.DefaultText;
import org.dom4j.tree.ElementIterator;
import org.dom4j.tree.ElementNameIterator;
import org.dom4j.tree.ElementQNameIterator;

public class DefaultElement
extends AbstractElement {
    private static final transient DocumentFactory DOCUMENT_FACTORY = DocumentFactory.getInstance();
    private QName qname;
    private Branch parentBranch;
    private Object content;
    private Object attributes;

    public DefaultElement(String string) {
        this.qname = DOCUMENT_FACTORY.createQName(string);
    }

    public DefaultElement(String string, Namespace namespace) {
        this.qname = DOCUMENT_FACTORY.createQName(string, namespace);
    }

    public DefaultElement(QName qName) {
        this.qname = qName;
    }

    public DefaultElement(QName qName, int n) {
        this.qname = qName;
        if (n > 1) {
            this.attributes = new ArrayList(n);
        }
    }

    public final void add(Attribute attribute) {
        if (attribute.getParent() != null) {
            String string = "The Attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"";
            throw new IllegalAddException(this, (Node)attribute, string);
        }
        if (attribute.getValue() == null) {
            Attribute attribute2 = this.attribute(attribute.getQName());
            if (attribute2 != null) {
                this.remove(attribute2);
            }
        } else {
            if (this.attributes == null) {
                this.attributes = attribute;
            } else {
                this.attributeList().add(attribute);
            }
            this.childAdded(attribute);
        }
    }

    protected final void addNewNode(Node node) {
        if (this.content == null) {
            this.content = node;
        } else if (this.content instanceof List) {
            List list = (List)this.content;
            list.add(node);
        } else {
            List list = this.createContentList();
            list.add(this.content);
            list.add(node);
            this.content = list;
        }
        this.childAdded(node);
    }

    public final List additionalNamespaces() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            int n = list.size();
            BackedList backedList = this.createResultList();
            int n2 = 0;
            while (n2 < n) {
                Object e2 = list.get(n2);
                if (e2 instanceof Namespace) {
                    Namespace namespace = (Namespace)e2;
                    backedList.addLocal(namespace);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof Namespace) {
            Namespace namespace = (Namespace)this.content;
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public final List additionalNamespaces(String string) {
        Namespace namespace;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList backedList = this.createResultList();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Namespace namespace2;
                Object e2 = list.get(n2);
                if (e2 instanceof Namespace && !string.equals((namespace2 = (Namespace)e2).getURI())) {
                    backedList.addLocal(namespace2);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof Namespace && !string.equals((namespace = (Namespace)this.content).getURI())) {
            return this.createSingleResultList(namespace);
        }
        return this.createEmptyList();
    }

    public final Attribute attribute(int n) {
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            return (Attribute)list.get(n);
        }
        if (this.attributes != null && n == 0) {
            return (Attribute)this.attributes;
        }
        return null;
    }

    public final Attribute attribute(String string) {
        Attribute attribute;
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute2 = (Attribute)list.get(n2);
                if (string.equals(attribute2.getName())) {
                    return attribute2;
                }
                ++n2;
            }
        } else if (this.attributes != null && string.equals((attribute = (Attribute)this.attributes).getName())) {
            return attribute;
        }
        return null;
    }

    public final Attribute attribute(String string, Namespace namespace) {
        return this.attribute(this.getDocumentFactory().createQName(string, namespace));
    }

    public final Attribute attribute(QName qName) {
        Attribute attribute;
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute2 = (Attribute)list.get(n2);
                if (qName.equals(attribute2.getQName())) {
                    return attribute2;
                }
                ++n2;
            }
        } else if (this.attributes != null && qName.equals((attribute = (Attribute)this.attributes).getQName())) {
            return attribute;
        }
        return null;
    }

    public final int attributeCount() {
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            return list.size();
        }
        return this.attributes != null ? 1 : 0;
    }

    public final Iterator attributeIterator() {
        if (this.attributes instanceof List) {
            List list = (List)this.attributes;
            return list.iterator();
        }
        if (this.attributes != null) {
            return this.createSingleIterator(this.attributes);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    protected final List attributeList() {
        if (this.attributes instanceof List) {
            return (List)this.attributes;
        }
        if (this.attributes != null) {
            List list = this.createAttributeList();
            list.add(this.attributes);
            this.attributes = list;
            return list;
        }
        List list = this.createAttributeList();
        this.attributes = list;
        return list;
    }

    protected final List attributeList(int n) {
        if (this.attributes instanceof List) {
            return (List)this.attributes;
        }
        if (this.attributes != null) {
            List list = this.createAttributeList(n);
            list.add(this.attributes);
            this.attributes = list;
            return list;
        }
        List list = this.createAttributeList(n);
        this.attributes = list;
        return list;
    }

    public final List attributes() {
        return new ContentListFacade(this, this.attributeList());
    }

    public final void clearContent() {
        if (this.content != null) {
            this.contentRemoved();
        }
        this.content = null;
    }

    public final Object clone() {
        DefaultElement defaultElement = (DefaultElement)super.clone();
        if (defaultElement != this) {
            defaultElement.content = null;
            defaultElement.attributes = null;
            defaultElement.appendAttributes(this);
            defaultElement.appendContent(this);
        }
        return defaultElement;
    }

    protected final List contentList() {
        if (this.content instanceof List) {
            return (List)this.content;
        }
        List list = this.createContentList();
        if (this.content != null) {
            list.add(this.content);
        }
        this.content = list;
        return list;
    }

    public final List declaredNamespaces() {
        BackedList backedList = this.createResultList();
        if (this.getNamespaceURI().length() > 0) {
            backedList.addLocal(this.getNamespace());
        }
        if (this.content instanceof List) {
            List list = (List)this.content;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object e2 = list.get(n2);
                if (e2 instanceof Namespace) {
                    backedList.addLocal(e2);
                }
                ++n2;
            }
        } else if (this.content instanceof Namespace) {
            backedList.addLocal(this.content);
        }
        return backedList;
    }

    public final Element element(String string) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                Object e2 = list.get(n2);
                if (e2 instanceof Element && string.equals((element2 = (Element)e2).getName())) {
                    return element2;
                }
                ++n2;
            }
        } else if (this.content instanceof Element && string.equals((element = (Element)this.content).getName())) {
            return element;
        }
        return null;
    }

    public final Element element(String string, Namespace namespace) {
        return this.element(this.getDocumentFactory().createQName(string, namespace));
    }

    public final Element element(QName qName) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                Object e2 = list.get(n2);
                if (e2 instanceof Element && qName.equals((element2 = (Element)e2).getQName())) {
                    return element2;
                }
                ++n2;
            }
        } else if (this.content instanceof Element && qName.equals((element = (Element)this.content).getQName())) {
            return element;
        }
        return null;
    }

    public final Iterator elementIterator() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return new ElementIterator(list.iterator());
        }
        if (this.content instanceof Element) {
            Element element = (Element)this.content;
            return this.createSingleIterator(element);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public final Iterator elementIterator(String string) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            return new ElementNameIterator(list.iterator(), string);
        }
        if (this.content instanceof Element && string.equals((element = (Element)this.content).getName())) {
            return this.createSingleIterator(element);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public final Iterator elementIterator(String string, Namespace namespace) {
        return this.elementIterator(this.getDocumentFactory().createQName(string, namespace));
    }

    public final Iterator elementIterator(QName qName) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            return new ElementQNameIterator(list.iterator(), qName);
        }
        if (this.content instanceof Element && qName.equals((element = (Element)this.content).getQName())) {
            return this.createSingleIterator(element);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public final List elements() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList backedList = this.createResultList();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object e2 = list.get(n2);
                if (e2 instanceof Element) {
                    backedList.addLocal(e2);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof Element) {
            Element element = (Element)this.content;
            return this.createSingleResultList(element);
        }
        return this.createEmptyList();
    }

    public final List elements(String string) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList backedList = this.createResultList();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                Object e2 = list.get(n2);
                if (e2 instanceof Element && string.equals((element2 = (Element)e2).getName())) {
                    backedList.addLocal(element2);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof Element && string.equals((element = (Element)this.content).getName())) {
            return this.createSingleResultList(element);
        }
        return this.createEmptyList();
    }

    public final List elements(String string, Namespace namespace) {
        return this.elements(this.getDocumentFactory().createQName(string, namespace));
    }

    public final List elements(QName qName) {
        Element element;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList backedList = this.createResultList();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Element element2;
                Object e2 = list.get(n2);
                if (e2 instanceof Element && qName.equals((element2 = (Element)e2).getQName())) {
                    backedList.addLocal(element2);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof Element && qName.equals((element = (Element)this.content).getQName())) {
            return this.createSingleResultList(element);
        }
        return this.createEmptyList();
    }

    public final Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element element = (Element)this.parentBranch;
            return element.getDocument();
        }
        return null;
    }

    protected final DocumentFactory getDocumentFactory() {
        DocumentFactory documentFactory = this.qname.getDocumentFactory();
        return documentFactory != null ? documentFactory : DOCUMENT_FACTORY;
    }

    public final Namespace getNamespaceForPrefix(String string) {
        Namespace namespace;
        Object object;
        if (string == null) {
            string = "";
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        if (this.content instanceof List) {
            object = (List)this.content;
            int n = object.size();
            int n2 = 0;
            while (n2 < n) {
                Namespace namespace2;
                Object e2 = object.get(n2);
                if (e2 instanceof Namespace && string.equals((namespace2 = (Namespace)e2).getPrefix())) {
                    return namespace2;
                }
                ++n2;
            }
        } else if (this.content instanceof Namespace && string.equals(((Namespace)(object = (Namespace)this.content)).getPrefix())) {
            return object;
        }
        object = this.getParent();
        if (object != null && (namespace = object.getNamespaceForPrefix(string)) != null) {
            return namespace;
        }
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        return null;
    }

    public final Namespace getNamespaceForURI(String string) {
        Object object;
        if (string == null || string.length() <= 0) {
            return Namespace.NO_NAMESPACE;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getNamespace();
        }
        if (this.content instanceof List) {
            object = (List)this.content;
            int n = object.size();
            int n2 = 0;
            while (n2 < n) {
                Namespace namespace;
                Object e2 = object.get(n2);
                if (e2 instanceof Namespace && string.equals((namespace = (Namespace)e2).getURI())) {
                    return namespace;
                }
                ++n2;
            }
        } else if (this.content instanceof Namespace && string.equals(((Namespace)(object = (Namespace)this.content)).getURI())) {
            return object;
        }
        object = this.getParent();
        if (object != null) {
            return object.getNamespaceForURI(string);
        }
        return null;
    }

    public final Element getParent() {
        return this.parentBranch instanceof Element ? (Element)this.parentBranch : null;
    }

    public final QName getQName() {
        return this.qname;
    }

    public final String getStringValue() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            int n = list.size();
            if (n > 0) {
                if (n == 1) {
                    return this.getContentAsStringValue(list.get(0));
                }
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < n) {
                    Object e2 = list.get(n2);
                    String string = this.getContentAsStringValue(e2);
                    if (string.length() > 0) {
                        stringBuffer.append(string);
                    }
                    ++n2;
                }
                return stringBuffer.toString();
            }
        } else if (this.content != null) {
            return this.getContentAsStringValue(this.content);
        }
        return "";
    }

    public final String getText() {
        if (this.content instanceof List) {
            return super.getText();
        }
        if (this.content != null) {
            return this.getContentAsText(this.content);
        }
        return "";
    }

    public final int indexOf(Node node) {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return list.indexOf(node);
        }
        return this.content != null && this.content.equals(node) ? 0 : -1;
    }

    public final Node node(int n) {
        if (n >= 0) {
            Object object = this.content;
            if (this.content instanceof List) {
                List list = (List)this.content;
                if (n >= list.size()) {
                    return null;
                }
                object = list.get(n);
            }
            if (object != null) {
                if (object instanceof Node) {
                    return (Node)object;
                }
                return new DefaultText(object.toString());
            }
        }
        return null;
    }

    public final int nodeCount() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return list.size();
        }
        return this.content != null ? 1 : 0;
    }

    public final Iterator nodeIterator() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            return list.iterator();
        }
        if (this.content != null) {
            return this.createSingleIterator(this.content);
        }
        return AbstractElement.EMPTY_ITERATOR;
    }

    public final ProcessingInstruction processingInstruction(String string) {
        ProcessingInstruction processingInstruction;
        if (this.content instanceof List) {
            List list = (List)this.content;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ProcessingInstruction processingInstruction2;
                Object e2 = list.get(n2);
                if (e2 instanceof ProcessingInstruction && string.equals((processingInstruction2 = (ProcessingInstruction)e2).getName())) {
                    return processingInstruction2;
                }
                ++n2;
            }
        } else if (this.content instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)this.content).getName())) {
            return processingInstruction;
        }
        return null;
    }

    public final List processingInstructions() {
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList backedList = this.createResultList();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object e2 = list.get(n2);
                if (e2 instanceof ProcessingInstruction) {
                    backedList.addLocal(e2);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof ProcessingInstruction) {
            return this.createSingleResultList(this.content);
        }
        return this.createEmptyList();
    }

    public final List processingInstructions(String string) {
        ProcessingInstruction processingInstruction;
        if (this.content instanceof List) {
            List list = (List)this.content;
            BackedList backedList = this.createResultList();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ProcessingInstruction processingInstruction2;
                Object e2 = list.get(n2);
                if (e2 instanceof ProcessingInstruction && string.equals((processingInstruction2 = (ProcessingInstruction)e2).getName())) {
                    backedList.addLocal(processingInstruction2);
                }
                ++n2;
            }
            return backedList;
        }
        if (this.content instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)this.content).getName())) {
            return this.createSingleResultList(processingInstruction);
        }
        return this.createEmptyList();
    }

    public final boolean remove(Attribute attribute) {
        boolean bl = false;
        if (this.attributes instanceof List) {
            Attribute attribute2;
            List list = (List)this.attributes;
            bl = list.remove(attribute);
            if (!bl && (attribute2 = this.attribute(attribute.getQName())) != null) {
                list.remove(attribute2);
                bl = true;
            }
        } else if (this.attributes != null) {
            if (attribute.equals(this.attributes)) {
                this.attributes = null;
                bl = true;
            } else {
                Attribute attribute3 = (Attribute)this.attributes;
                if (attribute.getQName().equals(attribute3.getQName())) {
                    this.attributes = null;
                    bl = true;
                }
            }
        }
        if (bl) {
            this.childRemoved(attribute);
        }
        return bl;
    }

    protected final boolean removeNode(Node node) {
        boolean bl = false;
        if (this.content != null) {
            if (this.content == node) {
                this.content = null;
                bl = true;
            } else if (this.content instanceof List) {
                List list = (List)this.content;
                bl = list.remove(node);
            }
        }
        if (bl) {
            this.childRemoved(node);
        }
        return bl;
    }

    public final boolean removeProcessingInstruction(String string) {
        ProcessingInstruction processingInstruction;
        if (this.content instanceof List) {
            List list = (List)this.content;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ProcessingInstruction processingInstruction2;
                Object e2 = iterator.next();
                if (!(e2 instanceof ProcessingInstruction) || !string.equals((processingInstruction2 = (ProcessingInstruction)e2).getName())) continue;
                iterator.remove();
                return true;
            }
        } else if (this.content instanceof ProcessingInstruction && string.equals((processingInstruction = (ProcessingInstruction)this.content).getName())) {
            this.content = null;
            return true;
        }
        return false;
    }

    protected final void setAttributeList(List list) {
        this.attributes = list;
    }

    public final void setAttributes(List list) {
        this.attributes = list;
        if (list instanceof ContentListFacade) {
            this.attributes = ((ContentListFacade)list).getBackingList();
        }
    }

    public final void setContent(List list) {
        if (list instanceof ContentListFacade) {
            list = ((ContentListFacade)list).getBackingList();
        }
        if (list == null) {
            this.content = null;
        } else {
            int n = list.size();
            List list2 = this.createContentList(n);
            int n2 = 0;
            while (n2 < n) {
                Node node;
                Object object;
                Object e2 = list.get(n2);
                if (e2 instanceof Node) {
                    object = (Node)e2;
                    node = object.getParent();
                    if (node != null && node != this) {
                        object = (Node)object.clone();
                    }
                    list2.add(object);
                    this.childAdded((Node)object);
                } else if (e2 != null) {
                    object = e2.toString();
                    node = this.getDocumentFactory().createText((String)object);
                    list2.add(node);
                    this.childAdded(node);
                }
                ++n2;
            }
            this.contentRemoved();
            this.content = list2;
        }
    }

    public final void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    public final void setParent(Element element) {
        if (this.parentBranch instanceof Element || element != null) {
            this.parentBranch = element;
        }
    }

    public final void setQName(QName qName) {
        this.qname = qName;
    }

    public final boolean supportsParent() {
        return true;
    }
}

