/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.XPath;
import org.dom4j.XPathException;
import org.dom4j.xpath.DefaultNamespaceContext;
import org.dom4j.xpath.DefaultXPath$1;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.saxpath.SAXPathException;

public class DefaultXPath
implements XPath,
NodeFilter,
Serializable {
    private String text;
    private org.jaxen.XPath xpath;
    private NamespaceContext namespaceContext;

    public DefaultXPath(String string) {
        this.text = string;
        this.xpath = DefaultXPath.parse(string);
    }

    public Object evaluate(Object object) {
        try {
            this.setNSContext(object);
            List list = this.xpath.selectNodes(object);
            if (list != null && list.size() == 1) {
                return list.get(0);
            }
            return list;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    protected Object getCompareValue(Node node) {
        return this.valueOf(node);
    }

    public FunctionContext getFunctionContext() {
        return this.xpath.getFunctionContext();
    }

    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public String getText() {
        return this.text;
    }

    public VariableContext getVariableContext() {
        return this.xpath.getVariableContext();
    }

    protected void handleJaxenException(JaxenException jaxenException) {
        throw new XPathException(this.text, jaxenException);
    }

    public boolean matches(Node node) {
        try {
            this.setNSContext(node);
            List list = this.xpath.selectNodes(node);
            if (list != null && list.size() > 0) {
                Object e2 = list.get(0);
                if (e2 instanceof Boolean) {
                    return (Boolean)e2;
                }
                return list.contains(node);
            }
            return false;
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    public Number numberValueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.numberValueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    protected static org.jaxen.XPath parse(String string) {
        try {
            return new Dom4jXPath(string);
        }
        catch (SAXPathException sAXPathException) {
            throw new InvalidXPathException(string, sAXPathException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidXPathException(string);
        }
    }

    protected void removeDuplicates(List list, Map map) {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object v = map.get(e2);
            if (hashSet.contains(v)) {
                iterator.remove();
                continue;
            }
            hashSet.add(v);
        }
    }

    public List selectNodes(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.selectNodes(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return Collections.EMPTY_LIST;
        }
    }

    public List selectNodes(Object object, XPath xPath) {
        List list = this.selectNodes(object);
        xPath.sort(list);
        return list;
    }

    public List selectNodes(Object object, XPath xPath, boolean bl) {
        List list = this.selectNodes(object);
        xPath.sort(list, bl);
        return list;
    }

    public Object selectObject(Object object) {
        return this.evaluate(object);
    }

    public Node selectSingleNode(Object object) {
        try {
            this.setNSContext(object);
            Object object2 = this.xpath.selectSingleNode(object);
            if (object2 instanceof Node) {
                return (Node)object2;
            }
            if (object2 == null) {
                return null;
            }
            throw new XPathException("The result of the XPath expression is not a Node. It was: " + object2 + " of type: " + object2.getClass().getName() + ". You might want to use a different method such as selectObject() to evaluate this XPath expression");
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return null;
        }
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.xpath.setFunctionContext(functionContext);
    }

    protected void setNSContext(Object object) {
        if (this.namespaceContext == null) {
            this.xpath.setNamespaceContext(DefaultNamespaceContext.create(object));
        }
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
        this.xpath.setNamespaceContext(namespaceContext);
    }

    public void setNamespaceURIs(Map map) {
        this.setNamespaceContext(new SimpleNamespaceContext(map));
    }

    public void setVariableContext(VariableContext variableContext) {
        this.xpath.setVariableContext(variableContext);
    }

    public void sort(List list) {
        this.sort(list, false);
    }

    protected void sort(List list, Map map) {
        Collections.sort(list, new DefaultXPath$1(map));
    }

    public void sort(List list, boolean bl) {
        if (list != null && !list.isEmpty()) {
            int n = list.size();
            HashMap<Node, Object> hashMap = new HashMap<Node, Object>(n);
            int n2 = 0;
            while (n2 < n) {
                Object e2 = list.get(n2);
                if (e2 instanceof Node) {
                    Node node = (Node)e2;
                    Object object = this.getCompareValue(node);
                    hashMap.put(node, object);
                }
                ++n2;
            }
            this.sort(list, hashMap);
            if (bl) {
                this.removeDuplicates(list, hashMap);
            }
        }
    }

    public String toString() {
        return "[XPath: " + this.xpath + "]";
    }

    public String valueOf(Object object) {
        try {
            this.setNSContext(object);
            return this.xpath.valueOf(object);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return "";
        }
    }
}

