/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.genepattern.annotation.FeatureClassEditor;
import org.genepattern.annotation.SampleClassEditor;
import org.genepattern.annotation.SetAnnotator$1;
import org.genepattern.annotation.SetAnnotator$2;
import org.genepattern.annotation.SetAnnotator$FeatureRenderer;
import org.genepattern.annotation.SetAnnotatorModel;
import org.genepattern.annotation.SparseClassVector;

public class SetAnnotator {
    Frame parent;
    SparseClassVector classVector = new SparseClassVector();
    int classNumberCounter = 0;
    static final Color[] colors = new Color[]{Color.red, Color.yellow, Color.blue, Color.GREEN, Color.ORANGE, Color.magenta, Color.CYAN, Color.PINK, Color.GRAY};
    private boolean annotateRow = true;
    SetAnnotatorModel model;
    SetAnnotator$FeatureRenderer featureRenderer;
    SampleClassEditor sampleClassEditor;
    FeatureClassEditor featureClassEditor;
    private JMenuItem openFeaturesMenuItem;
    private JMenuItem viewFeatureListsMenuItem;
    private JTable table;
    int widthPerClass = 6;

    public final int getAnnotationSizePerClass() {
        return this.widthPerClass;
    }

    public final void setTable(JTable jTable) {
        this.table = jTable;
    }

    public final int getLevels() {
        return this.classVector.levels();
    }

    public SetAnnotator(Frame frame, SetAnnotatorModel setAnnotatorModel) {
        this(frame, setAnnotatorModel, true);
    }

    public final SparseClassVector getClassVector() {
        return this.classVector;
    }

    public final void slice(int[] nArray) {
        this.classVector.slice(nArray);
        this.classVector.notifyListeners();
    }

    public SetAnnotator(Frame frame, SetAnnotatorModel setAnnotatorModel, boolean bl) {
        this.parent = frame;
        this.model = setAnnotatorModel;
        this.annotateRow = bl;
        this.featureRenderer = new SetAnnotator$FeatureRenderer(this);
        this.viewFeatureListsMenuItem = this.annotateRow ? new JMenuItem("Feature Annotations...") : new JMenuItem("Sample Annotations...");
        this.viewFeatureListsMenuItem.addActionListener(new SetAnnotator$1(this, frame, setAnnotatorModel));
        this.openFeaturesMenuItem = this.annotateRow ? new JMenuItem("Open Feature List(s)...") : new JMenuItem("Open Cls File...");
        this.openFeaturesMenuItem.addActionListener(new SetAnnotator$2(this, frame, setAnnotatorModel));
        if (this.annotateRow) {
            this.openFeaturesMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
    }

    final boolean addToFeatureList(List list, String string, Color color) {
        boolean bl = false;
        Integer n = new Integer(this.classNumberCounter);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2 = this.model.getIndex((String)list.get(i2));
            if (n2 == -1) {
                bl = true;
                continue;
            }
            this.classVector.addClass(n2, n);
        }
        if (color == null) {
            color = this.classNumberCounter >= colors.length ? new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)) : colors[this.classNumberCounter];
        }
        this.classVector.setClass(n, string, color);
        ++this.classNumberCounter;
        return bl;
    }

    public final TableCellRenderer getRenderer() {
        return this.featureRenderer;
    }

    public final JMenuItem getOpenFeaturesMenuItem() {
        return this.openFeaturesMenuItem;
    }

    public final JMenuItem getViewFeatureListsMenuItem() {
        return this.viewFeatureListsMenuItem;
    }

    static final /* synthetic */ boolean access$000(SetAnnotator setAnnotator) {
        return setAnnotator.annotateRow;
    }

    static final /* synthetic */ JTable access$100(SetAnnotator setAnnotator) {
        return setAnnotator.table;
    }
}

