/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.matrix;

public class ObjectMatrix2D {
    Object[][] matrix;

    public ObjectMatrix2D(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of rows must be greater than 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Number of columns must be greater than 0");
        }
        this.matrix = new Object[n][n2];
    }

    public ObjectMatrix2D(Object[][] objectArray) {
        this.matrix = objectArray;
    }

    public final Object[][] getArray() {
        return this.matrix;
    }

    public final Object[] getRow(int n) {
        return this.matrix[n];
    }

    public final ObjectMatrix2D slice(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.getRowCount()];
            n = this.getRowCount();
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.getColumnCount()];
            n = this.getColumnCount();
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        Object[][] objectArray = new Object[nArray.length][nArray2.length];
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                objectArray[i2][i3] = this.matrix[nArray[i2]][nArray2[i3]];
            }
        }
        return new ObjectMatrix2D(objectArray);
    }

    public final void set(int n, int n2, Object object) {
        this.matrix[n][n2] = object;
    }

    public final Object get(int n, int n2) {
        return this.matrix[n][n2];
    }

    public final int getRowCount() {
        return this.matrix.length;
    }

    public final int getColumnCount() {
        return this.matrix[0].length;
    }

    public final ObjectMatrix2D transpose() {
        ObjectMatrix2D objectMatrix2D = new ObjectMatrix2D(this.getColumnCount(), this.getRowCount());
        Object[][] objectArray = objectMatrix2D.getArray();
        int n = this.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = this.getColumnCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                objectArray[i3][i2] = this.matrix[i2][i3];
            }
        }
        return objectMatrix2D;
    }
}

