/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import java.awt.Frame;
import java.io.File;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.genepattern.gsea.HCLAlgorithm;
import org.genepattern.gsea.LeadingEdgePanel$1;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapComponent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;

public class LeadingEdgePanel {
    private HeatMapComponent heatMap;
    private File resultDirectory;

    public LeadingEdgePanel(Frame frame, JPanel jPanel) {
        this.heatMap = new HeatMapComponent(frame, IExpressionDataUtil.createRandomData(1, 1), null, null, jPanel);
        this.heatMap.setFeatureUIString("Gene Set");
        this.heatMap.setSampleUIString("Gene");
        this.heatMap.setShowFeatureAnnotator(false);
        this.heatMap.setShowRowDescriptions(false);
        this.heatMap.setShowSampleAnnotator(false);
        this.heatMap.setShowColorSchemeOptions(false);
        JTable jTable = this.heatMap.getFeatureTable();
        jTable.addMouseListener(new LeadingEdgePanel$1(this, jTable));
    }

    public final void setResultDirectory(File file) {
        this.resultDirectory = file;
    }

    public final void setData(IExpressionData iExpressionData, boolean bl, ColorScheme colorScheme) {
        this.heatMap.setColorConverter(colorScheme);
        if (bl) {
            int n = -1;
            int n2 = 4;
            int n3 = 2;
            try {
                if (iExpressionData.getRowCount() > 0 && iExpressionData.getColumnCount() > 0) {
                    HCLAlgorithm hCLAlgorithm = new HCLAlgorithm(iExpressionData, n, n2, n3);
                    iExpressionData = IExpressionDataUtil.sliceView(iExpressionData, hCLAlgorithm.getGenes_order(), hCLAlgorithm.getSamples_order());
                }
            }
            catch (AlgorithmException algorithmException) {
                algorithmException.printStackTrace();
            }
        }
        this.heatMap.setExpressionData(iExpressionData);
    }

    public final JMenuBar getMenuBar() {
        this.heatMap.setOptionsDialogOptions(false, false, false);
        return this.heatMap.createMenuBar(false, false, false, false);
    }

    public final HeatMapComponent getHeatMapComponent() {
        return this.heatMap;
    }

    public final void showLegend() {
        this.heatMap.showLegend();
    }

    public final void showSaveDatasetDialog() {
        this.heatMap.showSaveDatasetDialog();
    }

    public final void showSaveImageDialog(String string) {
        this.heatMap.showSaveImageDialog(string);
    }

    public final void showOptionsDialog() {
        this.heatMap.showOptionsDialog();
    }

    static final /* synthetic */ File access$000(LeadingEdgePanel leadingEdgePanel) {
        return leadingEdgePanel.resultDirectory;
    }
}

