/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.GradientColorScheme$Legend;

public class GradientColorScheme
implements ColorScheme {
    double min;
    double max;
    double mid;
    IExpressionData data;
    BufferedImage posImage;
    BufferedImage negImage;
    boolean useDoubleGradient = true;

    public GradientColorScheme(double d2, double d3, double d4, Color color, Color color2, Color color3) {
        this.min = d2;
        this.max = d3;
        this.mid = d4;
        this.posImage = this.createGradientImage(color3, color);
        this.negImage = this.createGradientImage(color2, color3);
    }

    private BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        graphics2D.dispose();
        return bufferedImage;
    }

    public final void setUseDoubleGradient(boolean bl) {
        this.useDoubleGradient = bl;
    }

    @Override
    public final Color getColor(int n, int n2) {
        int n3;
        double d2 = this.data.getValue(n, n2);
        if (this.useDoubleGradient) {
            double d3 = d2 < this.mid ? this.min : this.max;
            int n4 = (int)(255.0 * (d2 - this.mid) / (d3 - this.mid));
            n4 = n4 > 255 ? 255 : n4;
            n3 = d2 < this.mid ? this.negImage.getRGB(255 - n4, 0) : this.posImage.getRGB(n4, 0);
        } else {
            double d4 = this.max - this.min;
            int n5 = 0;
            n5 = d2 <= this.min ? 0 : (d2 >= this.max ? 255 : (int)((d2 - this.min) / d4 * 255.0));
            n3 = this.posImage.getRGB(n5, 0);
        }
        return new Color(n3);
    }

    @Override
    public final void setDataset(IExpressionData iExpressionData) {
        this.data = iExpressionData;
    }

    @Override
    public final Component getLegend() {
        return new GradientColorScheme$Legend(this.min, this.mid, this.max, this.negImage, this.posImage, this.useDoubleGradient);
    }
}

