/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.UIResource;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapPanel$ToolTipProvider;
import org.genepattern.heatmap.PixelConverter;
import org.genepattern.heatmap.RowColorScheme;

public class HeatMapPanel
extends JPanel {
    public static int COLOR_RESPONSE_LOG = 0;
    public static int COLOR_RESPONSE_LINEAR = 1;
    public static int NORMALIZATION_ROW = 0;
    public static int NORMALIZATION_GLOBAL = 1;
    private IExpressionData data;
    int columnSize = 8;
    int rowSize = 8;
    private boolean drawGrid = true;
    private Color borderColor = Color.black;
    private ColorScheme colorConverter;
    private int normalization = NORMALIZATION_ROW;
    private boolean showToolTip = true;
    private PixelConverter pixelConverter;
    private PropertyChangeSupport changeSupport;
    private boolean upperTriangular = false;
    private boolean showNamesInToolTipText = true;
    private NumberFormat numberFormat;
    private HeatMapPanel$ToolTipProvider toolTipProvider;

    public HeatMapPanel(IExpressionData iExpressionData) {
        this(iExpressionData, RowColorScheme.getDefaultColorMap());
    }

    public HeatMapPanel(IExpressionData iExpressionData, Color[] colorArray) {
        this.data = iExpressionData;
        this.colorConverter = RowColorScheme.getRowInstance(colorArray);
        this.colorConverter.setDataset(iExpressionData);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.pixelConverter = new PixelConverter(this);
        this.pixelConverter.rowSize = this.rowSize;
        this.pixelConverter.columnSize = this.columnSize;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(4);
    }

    @Override
    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public final synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public final synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public final synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final IExpressionData getData() {
        return this.data;
    }

    public final void setExpressionData(IExpressionData iExpressionData) {
        this.data = iExpressionData;
        this.colorConverter.setDataset(iExpressionData);
        this.repaint();
    }

    public final void setShowToolTipText(boolean bl) {
        this.showToolTip = bl;
    }

    public final void setShowNamesInToolTipText(boolean bl) {
        this.showNamesInToolTipText = bl;
    }

    public final void setToolTipProvider(HeatMapPanel$ToolTipProvider heatMapPanel$ToolTipProvider) {
        this.toolTipProvider = heatMapPanel$ToolTipProvider;
    }

    @Override
    public final String getToolTipText(MouseEvent mouseEvent) {
        if (!this.showToolTip) {
            return null;
        }
        int n = this.pixelConverter.columnAtPoint(mouseEvent.getPoint());
        int n2 = this.pixelConverter.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n < this.data.getColumnCount() && n2 >= 0 && n2 < this.data.getRowCount()) {
            if (this.toolTipProvider != null) {
                return this.toolTipProvider.getToolTipText(n2, n);
            }
            String string = this.numberFormat.format(this.data.getValue(n2, n));
            return this.showNamesInToolTipText ? "<html>" + string + "<br>" + this.data.getRowName(n2) + "<br>" + this.data.getColumnName(n) : string;
        }
        return null;
    }

    public final Point cellAtPoint(Point point) {
        int n = this.pixelConverter.columnAtPoint(point);
        int n2 = this.pixelConverter.rowAtPoint(point);
        return new Point(n, n2);
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        super.paintComponent(graphics);
        int n5 = this.data.getColumnCount();
        Rectangle rectangle = graphics.getClipBounds();
        int n6 = 0;
        int n7 = n5;
        int n8 = 0;
        int n9 = this.data.getRowCount();
        if (rectangle != null) {
            n8 = this.pixelConverter.getTopIndex(rectangle.y);
            n9 = this.pixelConverter.getBottomIndex(rectangle.y + rectangle.height, this.data.getRowCount());
            n6 = this.pixelConverter.getLeftIndex(rectangle.x);
            n7 = this.pixelConverter.getRightIndex(rectangle.x + rectangle.width, n5);
        }
        for (n4 = n8; n4 < n9; ++n4) {
            for (n3 = n6; n3 < n7; ++n3) {
                n2 = n3 * this.columnSize + this.getInsets().left;
                n = n4 * this.rowSize + this.getInsets().top;
                if (this.upperTriangular && n3 < n4) continue;
                graphics.setColor(this.colorConverter.getColor(n4, n3));
                graphics.fillRect(n2, n, this.columnSize, this.rowSize);
            }
        }
        if (this.drawGrid) {
            int n10;
            graphics.setColor(this.borderColor);
            n4 = n6 * this.columnSize + this.getInsets().left;
            n3 = n7 * this.columnSize + this.getInsets().left;
            for (n2 = n8; n2 <= n9; ++n2) {
                n = n2 * this.rowSize + this.getInsets().top;
                if (this.upperTriangular) {
                    n10 = (n2 - 1) * this.columnSize + this.getInsets().left;
                    graphics.drawLine(n10, n, n3, n);
                    continue;
                }
                graphics.drawLine(n4, n, n3, n);
            }
            n2 = this.getInsets().top + this.rowSize * n8;
            n = this.getInsets().top + this.rowSize * n9;
            for (n10 = n6; n10 <= n7; ++n10) {
                int n11 = n10 * this.columnSize + this.getInsets().left;
                if (this.upperTriangular) {
                    int n12 = this.rowSize * (n10 + 1) + this.getInsets().top;
                    if (n10 == n5) {
                        n12 -= this.rowSize;
                    }
                    graphics.drawLine(n11, n2, n11, n12);
                    continue;
                }
                graphics.drawLine(n11, n2, n11, n);
            }
        }
    }

    @Override
    public final void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    @Override
    public final void removeNotify() {
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected final void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected final void unconfigureEnclosingScrollPane() {
        JScrollPane jScrollPane;
        JViewport jViewport;
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && ((jViewport = (jScrollPane = (JScrollPane)container).getViewport()) == null || jViewport.getView() != this)) {
            return;
        }
    }

    @Override
    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null && object != null && !object.equals(object2)) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(this.columnSize * this.data.getColumnCount() + 1, this.rowSize * (this.data.getRowCount() + 1));
    }

    public final int getRowSize() {
        return this.rowSize;
    }

    public final void setRowSize(int n) {
        this.pixelConverter.rowSize = this.rowSize = n;
        this.firePropertyChange("rowSize", new Integer(n), new Integer(this.rowSize));
    }

    public final int getColumnSize() {
        return this.columnSize;
    }

    public final void setColumnSize(int n) {
        this.pixelConverter.columnSize = this.columnSize = n;
        this.firePropertyChange("columnSize", new Integer(n), new Integer(this.columnSize));
    }

    public final boolean isDrawGrid() {
        return this.drawGrid;
    }

    public final void setDrawGrid(boolean bl) {
        this.drawGrid = bl;
    }

    public final int getNormalization() {
        return this.normalization;
    }

    public final void setNormalization(int n) {
        this.normalization = n;
        if (this.colorConverter instanceof RowColorScheme) {
            ((RowColorScheme)this.colorConverter).setGlobalScale(n == NORMALIZATION_GLOBAL);
        }
    }

    public final void setColorConverter(ColorScheme colorScheme) {
        this.colorConverter = colorScheme;
        colorScheme.setDataset(this.data);
    }

    public final ColorScheme getColorConverter() {
        return this.colorConverter;
    }

    public final boolean isUpperTriangular() {
        return this.upperTriangular;
    }

    public final void setUpperTriangular(boolean bl) {
        this.upperTriangular = bl;
    }
}

