/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Color;
import java.awt.Component;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.LegendPanel;

public class RowColorScheme
implements ColorScheme {
    public static int COLOR_RESPONSE_LOG = 0;
    public static int COLOR_RESPONSE_LINEAR = 1;
    int response = COLOR_RESPONSE_LINEAR;
    IExpressionData dataset;
    int lastRow = -1;
    static Color missingColor = Color.BLACK;
    private double min = 0.0;
    private double max = 8000.0;
    private double mean = Double.NEGATIVE_INFINITY;
    private final Color[] colors;
    private final double[] slots;
    private static int[] defaultColorMap = new int[]{4522157, 2556113, 7035119, 0x8888FF, 13091327, 0xD5D5FF, 16761061, 0xFF8989, 16740480, 0xFF5A5A, 15679552, 14027776};
    private boolean globalScale;

    public static final RowColorScheme getRowInstance() {
        return new RowColorScheme(COLOR_RESPONSE_LINEAR);
    }

    public static final RowColorScheme getRowInstance(Color[] colorArray) {
        return new RowColorScheme(colorArray, COLOR_RESPONSE_LINEAR, false);
    }

    public static final RowColorScheme getGlobalInstance() {
        return new RowColorScheme(RowColorScheme.getDefaultColorMap(), COLOR_RESPONSE_LINEAR, true);
    }

    public static final RowColorScheme getGlobalInstance(Color[] colorArray) {
        return new RowColorScheme(colorArray, COLOR_RESPONSE_LINEAR, true);
    }

    public static final Color[] getDefaultColorMap() {
        return RowColorScheme.getColorMap(defaultColorMap);
    }

    public final Color[] getColorMap() {
        return this.colors;
    }

    private static Color[] getColorMap(int[] nArray) {
        Color[] colorArray = new Color[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            colorArray[i2] = new Color(nArray[i2]);
        }
        return colorArray;
    }

    public RowColorScheme(int[] nArray, int n) {
        this(RowColorScheme.getColorMap(nArray), n, false);
    }

    public RowColorScheme(Color[] colorArray, int n, boolean bl) {
        this.colors = colorArray;
        this.slots = new double[colorArray.length];
        if (n != COLOR_RESPONSE_LINEAR && n != COLOR_RESPONSE_LOG) {
            throw new IllegalArgumentException("Unkown color response");
        }
        this.response = n;
        this.globalScale = bl;
    }

    public RowColorScheme(int n) {
        this(defaultColorMap, n);
    }

    @Override
    public final void setDataset(IExpressionData iExpressionData) {
        this.dataset = iExpressionData;
        this.setGlobalScale(this.globalScale);
        this.lastRow = -1;
    }

    public final IExpressionData getDataset() {
        return this.dataset;
    }

    public final void globalScale(double d2, double d3, double d4) {
        this.globalScale = true;
        this.min = d2;
        this.max = d3;
        this.mean = d4;
        this.calculateSlots(d2, d3, d4, this.slots);
    }

    public final void setGlobalScale(boolean bl) {
        this.globalScale = bl;
        if (this.globalScale) {
            int n;
            this.max = -1.7976931348623157E308;
            this.min = Double.MAX_VALUE;
            this.mean = 0.0;
            int n2 = this.dataset.getRowCount();
            for (n = 0; n < n2; ++n) {
                int n3 = this.dataset.getColumnCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    double d2 = this.dataset.getValue(n, i2);
                    this.max = d2 > this.max ? d2 : this.max;
                    this.min = d2 < this.min ? d2 : this.min;
                    this.mean += d2;
                }
            }
            n = this.dataset.getColumnCount() * this.dataset.getRowCount();
            this.mean /= (double)n;
            this.calculateSlots(this.min, this.max, this.mean, this.slots);
        }
    }

    public final void setColorResponse(int n) {
        if (n != COLOR_RESPONSE_LINEAR && n != COLOR_RESPONSE_LOG) {
            throw new IllegalArgumentException("Unkown color response");
        }
        if (this.response != n) {
            this.response = n;
        }
    }

    @Override
    public final Color getColor(int n, int n2) {
        double d2;
        if (!this.globalScale && this.lastRow != n) {
            this.calculateRowStats(n);
            this.lastRow = n;
        }
        if (Double.isNaN(d2 = this.dataset.getValue(n, n2))) {
            return missingColor;
        }
        int n3 = this.slots.length - 1;
        if (d2 >= this.slots[n3]) {
            return this.colors[n3];
        }
        for (int i2 = n3; i2 > 0; --i2) {
            if (!(this.slots[i2] > d2) || !(d2 > this.slots[i2 - 1])) continue;
            return this.colors[i2];
        }
        return this.colors[0];
    }

    public final Color getColorAt(int n) {
        return this.colors[n];
    }

    public final int getColorCount() {
        return this.colors.length;
    }

    public final double[] getSlots() {
        double[] dArray = new double[this.slots.length + 1];
        dArray[0] = this.min;
        System.arraycopy(this.slots, 0, dArray, 1, this.slots.length);
        return dArray;
    }

    final void calculateSlots(double d2, double d3, double d4, double[] dArray) {
        if (this.response == COLOR_RESPONSE_LOG) {
            this.computeLogScaleSlots(d2, d3, d4, dArray);
        } else {
            this.computeLinearSlots(d2, d3, d4, dArray);
        }
    }

    private void calculateRowStats(int n) {
        int n2 = this.dataset.getColumnCount();
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = 0.0;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = this.dataset.getValue(n, i2);
            if (Double.isNaN(d5)) continue;
            if (d5 < d2) {
                d2 = d5;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            d4 += d5;
            ++n3;
        }
        this.min = d2;
        this.max = d3;
        this.mean = d4 /= (double)n3;
        this.calculateSlots(this.min, this.max, this.mean, this.slots);
    }

    private void computeLogScaleSlots(double d2, double d3, double d4, double[] dArray) {
        double d5;
        double d6 = 1.0;
        double d7 = d3 - d2 + 1.0;
        double d8 = d4 - d2 + 1.0;
        double d9 = Math.log(d7) - Math.log(1.0);
        int n = dArray.length;
        double d10 = d5 = d9 / (double)n;
        double d11 = d2 - 1.0;
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = Math.exp(d10) + d11;
            d10 += d5;
        }
    }

    private void computeLinearSlots(double d2, double d3, double d4, double[] dArray) {
        double d5 = d4 == Double.NEGATIVE_INFINITY ? (d3 - d2) / 2.0 : d4;
        int n = dArray.length;
        int n2 = dArray.length / 2;
        double d6 = (d5 - d2) / (double)n2;
        double d7 = d2;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = d7 += d6;
        }
        double d8 = (d3 - d5) / (double)(n - n2);
        d7 = d5;
        for (int i3 = n2; i3 < n; ++i3) {
            dArray[i3] = d7 += d8;
        }
    }

    @Override
    public final Component getLegend() {
        LegendPanel legendPanel = new LegendPanel();
        if (!this.globalScale) {
            legendPanel.setRelativeGrid(this);
        } else {
            legendPanel.setAbsoluteGrid(this);
        }
        return legendPanel;
    }
}

