/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.genepattern.heatmap.image.HeatMap;
import org.genepattern.heatmap.image.SampleAnnotator;

public class HeatMapHeader {
    HeatMap heatMap;
    boolean drawSampleNames = true;
    Font font;
    int height = 0;
    private int sampleNameHeight;
    private final int spacer = 10;
    private int leftInsets = 0;

    public HeatMapHeader(HeatMap heatMap) {
        this.heatMap = heatMap;
    }

    public final void updateSize(int n, int n2, Graphics2D graphics2D) {
        this.setElementWidth(n2);
        if (this.heatMap.antiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = 0;
        this.sampleNameHeight = 0;
        if (this.drawSampleNames) {
            for (int i2 = 0; i2 < this.heatMap.data.getColumnCount(); ++i2) {
                String string = this.heatMap.data.getColumnName(i2);
                this.sampleNameHeight = Math.max(this.sampleNameHeight, fontMetrics.stringWidth(string));
            }
        }
        n3 += this.sampleNameHeight;
        if (this.heatMap.sampleAnnotator != null) {
            n3 += this.getAnnotationsHeight();
        }
        if (this.drawSampleNames) {
            n3 += 10;
        }
        this.height = n3;
    }

    public final void setLeftInset(int n) {
        this.leftInsets = n;
    }

    final void draw(Graphics2D graphics2D) {
        if (this.heatMap.antiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawHeader(graphics2D);
    }

    final void setShowSampleNames(boolean bl) {
        this.drawSampleNames = bl;
    }

    private final boolean isShowingSampleNames() {
        return this.drawSampleNames;
    }

    private void drawHeader(Graphics2D graphics2D) {
        int n;
        Object object;
        int n2;
        SampleAnnotator sampleAnnotator;
        int n3 = this.heatMap.data.getColumnCount();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(Color.black);
        int n4 = -this.height;
        int n5 = this.getAnnotationsHeight();
        if (n5 > 0) {
            n4 += n5;
        }
        if ((sampleAnnotator = this.heatMap.sampleAnnotator) != null && sampleAnnotator.hasPhenotypeColors()) {
            for (n2 = 0; n2 < n3; ++n2) {
                object = sampleAnnotator.getPhenotypeColor(this.heatMap.data.getColumnName(n2));
                if (object == null) continue;
                graphics2D.setColor((Color)object);
                n = this.height - n5;
                int n6 = n - this.sampleNameHeight - fontMetrics.getMaxAdvance();
                graphics2D.fillRect(n2 * this.heatMap.elementSize.width + this.leftInsets, n6, this.heatMap.elementSize.width, this.sampleNameHeight + fontMetrics.getMaxAdvance());
            }
        }
        if (this.drawSampleNames) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.rotate(-1.5707963267948966);
            for (n2 = 0; n2 < n3; ++n2) {
                object = this.heatMap.data.getColumnName(n2);
                graphics2D.drawString((String)object, n4, fontMetrics.getAscent() + this.heatMap.elementSize.width * n2 + this.leftInsets);
            }
            graphics2D.rotate(1.5707963267948966);
        }
        if (this.heatMap.numSampleClasses > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                object = sampleAnnotator.getColors(this.heatMap.data.getColumnName(n2));
                if (object == null) continue;
                for (n = 0; n < object.size(); ++n) {
                    Color color = (Color)object.get(n);
                    if (color == null) continue;
                    graphics2D.setColor(color);
                    int n7 = this.height - (n + 1) * this.heatMap.ds.sampleAnnonationsHeight - n * this.heatMap.ds.sampleAnnotationSpacing - 10;
                    graphics2D.fillRect(n2 * this.heatMap.elementSize.width + this.leftInsets, n7, this.heatMap.elementSize.width, this.heatMap.ds.sampleAnnonationsHeight);
                }
            }
            Font font = graphics2D.getFont();
            graphics2D.setColor(Color.BLACK);
            graphics2D.setFont(new Font(this.heatMap.fontFamilyName, this.heatMap.fontStyle, this.heatMap.ds.sampleAnnonationsHeight));
            for (int i2 = 0; i2 < this.heatMap.numSampleClasses; ++i2) {
                String string = sampleAnnotator.getLabel(i2);
                if (string == null) continue;
                int n8 = this.height - (i2 + 1) * this.heatMap.ds.sampleAnnonationsHeight - i2 * this.heatMap.ds.sampleAnnotationSpacing - 10;
                graphics2D.drawString(string, n3 * this.heatMap.elementSize.width + this.leftInsets + 10, n8 + fontMetrics.getAscent());
            }
            graphics2D.setFont(font);
        }
    }

    private void setElementWidth(int n) {
        n = Math.min(n, 14);
        this.font = new Font(this.heatMap.fontFamilyName, this.heatMap.fontStyle, n);
    }

    private int getAnnotationsHeight() {
        return this.heatMap.numSampleClasses > 0 ? this.heatMap.ds.sampleAnnonationsHeight * this.heatMap.numSampleClasses + this.heatMap.numSampleClasses * this.heatMap.ds.sampleAnnotationSpacing + 10 : 10;
    }
}

